/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.parser;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import com.thalesgroup.jenkinsci.plugins.cppcheck.model.Error;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jenkinsci.plugins.cppcheck.model.Cppcheck;
import org.jenkinsci.plugins.cppcheck.model.Error;
import org.jenkinsci.plugins.cppcheck.model.Errors;
import org.jenkinsci.plugins.cppcheck.model.Results;

public class CppcheckParser
implements Serializable {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CppcheckReport parse(File file) throws IOException {
        CppcheckReport report;
        if (file == null) {
            throw new IllegalArgumentException("File input is mandatory.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File input " + file.getName() + " must exist.");
        }
        AtomicReference<JAXBContext> jc = new AtomicReference<JAXBContext>();
        try {
            Thread t = Thread.currentThread();
            ClassLoader orig = t.getContextClassLoader();
            t.setContextClassLoader(CppcheckParser.class.getClassLoader());
            try {
                jc.set(JAXBContext.newInstance((Class[])new Class[]{org.jenkinsci.plugins.cppcheck.model.Error.class, Errors.class, Cppcheck.class, Results.class}));
            }
            finally {
                t.setContextClassLoader(orig);
            }
            Unmarshaller unmarshaller = ((JAXBContext)jc.get()).createUnmarshaller();
            Results results = (Results)unmarshaller.unmarshal(file);
            if (results.getCppcheck() == null) {
                throw new JAXBException("Test with versio 1");
            }
            report = this.getReportVersion2(results);
        }
        catch (JAXBException jxe) {
            try {
                Thread t = Thread.currentThread();
                ClassLoader orig = t.getContextClassLoader();
                t.setContextClassLoader(CppcheckParser.class.getClassLoader());
                try {
                    jc.set(JAXBContext.newInstance((Class[])new Class[]{Error.class, com.thalesgroup.jenkinsci.plugins.cppcheck.model.Results.class}));
                }
                finally {
                    t.setContextClassLoader(orig);
                }
                Unmarshaller unmarshaller = ((JAXBContext)jc.get()).createUnmarshaller();
                com.thalesgroup.jenkinsci.plugins.cppcheck.model.Results results = (com.thalesgroup.jenkinsci.plugins.cppcheck.model.Results)unmarshaller.unmarshal(file);
                report = this.getReportVersion1(results);
            }
            catch (JAXBException jxe1) {
                throw new IOException(jxe1);
            }
        }
        return report;
    }

    private CppcheckReport getReportVersion1(com.thalesgroup.jenkinsci.plugins.cppcheck.model.Results results) {
        CppcheckReport cppCheckReport = new CppcheckReport();
        ArrayList<CppcheckFile> everyErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> styleSeverities = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> possibleStyleSeverities = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> errorSeverities = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> possibleErrorSeverities = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> noCategorySeverities = new ArrayList<CppcheckFile>();
        for (int i = 0; i < results.getError().size(); ++i) {
            Error error = results.getError().get(i);
            CppcheckFile cppcheckFile = new CppcheckFile();
            cppcheckFile.setFileName(error.getFile());
            String lineAtr = error.getLine();
            if (lineAtr != null) {
                cppcheckFile.setLineNumber(Integer.parseInt(lineAtr));
            }
            cppcheckFile.setCppCheckId(error.getId());
            cppcheckFile.setSeverity(error.getSeverity());
            cppcheckFile.setMessage(error.getMsg());
            if ("possible error".equals(cppcheckFile.getSeverity())) {
                possibleErrorSeverities.add(cppcheckFile);
            } else if ("style".equals(cppcheckFile.getSeverity())) {
                styleSeverities.add(cppcheckFile);
            } else if ("possible style".equals(cppcheckFile.getSeverity())) {
                possibleStyleSeverities.add(cppcheckFile);
            } else if ("error".equals(cppcheckFile.getSeverity())) {
                errorSeverities.add(cppcheckFile);
            } else {
                noCategorySeverities.add(cppcheckFile);
            }
            everyErrors.add(cppcheckFile);
        }
        cppCheckReport.setEverySeverities(everyErrors);
        cppCheckReport.setPossibleErrorSeverities(possibleErrorSeverities);
        cppCheckReport.setStyleSeverities(styleSeverities);
        cppCheckReport.setPossibleStyleSeverities(possibleStyleSeverities);
        cppCheckReport.setErrorSeverities(errorSeverities);
        cppCheckReport.setNoCategorySeverities(noCategorySeverities);
        return cppCheckReport;
    }

    private CppcheckReport getReportVersion2(Results results) {
        CppcheckReport cppCheckReport = new CppcheckReport();
        ArrayList<CppcheckFile> everyErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> styleSeverities = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> possibleStyleSeverities = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> errorSeverities = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> possibleErrorSeverities = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> noCategorySeverities = new ArrayList<CppcheckFile>();
        Errors errors = results.getErrors();
        if (errors != null) {
            for (int i = 0; i < errors.getError().size(); ++i) {
                org.jenkinsci.plugins.cppcheck.model.Error error = errors.getError().get(i);
                CppcheckFile cppcheckFile = new CppcheckFile();
                Error.Location location = error.getLocation();
                if (location != null) {
                    cppcheckFile.setFileName(location.getFile());
                    String lineAtr = location.getLine();
                    if (lineAtr != null) {
                        cppcheckFile.setLineNumber(Integer.parseInt(lineAtr));
                    }
                }
                cppcheckFile.setCppCheckId(error.getId());
                cppcheckFile.setSeverity(error.getSeverity());
                cppcheckFile.setMessage(error.getMsg());
                if ("possible error".equals(cppcheckFile.getSeverity())) {
                    possibleErrorSeverities.add(cppcheckFile);
                } else if ("warning".equals(cppcheckFile.getSeverity())) {
                    possibleErrorSeverities.add(cppcheckFile);
                } else if ("style".equals(cppcheckFile.getSeverity())) {
                    styleSeverities.add(cppcheckFile);
                } else if ("possible style".equals(cppcheckFile.getSeverity())) {
                    possibleStyleSeverities.add(cppcheckFile);
                } else if ("information".equals(cppcheckFile.getSeverity())) {
                    possibleStyleSeverities.add(cppcheckFile);
                } else if ("error".equals(cppcheckFile.getSeverity())) {
                    errorSeverities.add(cppcheckFile);
                } else {
                    noCategorySeverities.add(cppcheckFile);
                }
                everyErrors.add(cppcheckFile);
            }
        }
        cppCheckReport.setEverySeverities(everyErrors);
        cppCheckReport.setPossibleErrorSeverities(possibleErrorSeverities);
        cppCheckReport.setStyleSeverities(styleSeverities);
        cppCheckReport.setPossibleStyleSeverities(possibleStyleSeverities);
        cppCheckReport.setErrorSeverities(errorSeverities);
        cppCheckReport.setNoCategorySeverities(noCategorySeverities);
        return cppCheckReport;
    }
}

