/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.model;

import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import hudson.model.Run;
import java.io.File;
import java.io.Serializable;
import org.jenkinsci.plugins.cppcheck.CppcheckDiffState;

public class CppcheckWorkspaceFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DIR_WORKSPACE_FILES = "workspace-files";
    private String fileName;
    private CppcheckFile cppcheckFile;
    private boolean sourceIgnored;
    private transient CppcheckDiffState diffState = null;

    public CppcheckWorkspaceFile(File file) {
        if (file != null) {
            this.fileName = file.getAbsolutePath().replace('\\', '/');
        }
    }

    public CppcheckWorkspaceFile() {
    }

    public CppcheckFile getCppcheckFile() {
        return this.cppcheckFile;
    }

    public void setCppcheckFile(CppcheckFile cppcheckFile) {
        this.cppcheckFile = cppcheckFile;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        if (fileName == null) {
            this.setSourceIgnored(true);
        }
    }

    public String getTempName() {
        return Integer.toHexString(this.getFileName().hashCode()) + ".tmp";
    }

    public final String getFileName() {
        return this.fileName;
    }

    public String getTempName(Run<?, ?> owner) {
        if (this.fileName != null) {
            return owner.getRootDir().getAbsolutePath() + "/" + DIR_WORKSPACE_FILES + "/" + Integer.toHexString(this.fileName.hashCode()) + ".tmp";
        }
        return "";
    }

    public boolean isSourceIgnored() {
        return this.sourceIgnored;
    }

    public void setSourceIgnored(boolean sourceIgnored) {
        this.sourceIgnored = sourceIgnored;
    }

    public CppcheckDiffState getDiffState() {
        return this.diffState;
    }

    public void setDiffState(CppcheckDiffState diffState) {
        this.diffState = diffState;
    }
}

