/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.model;

import hudson.model.ModelObject;
import java.io.Serializable;
import org.apache.commons.lang.StringEscapeUtils;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class CppcheckFile
implements ModelObject,
Serializable {
    private static final long serialVersionUID = 3L;
    private Integer key;
    private String fileName;
    private int lineNumber;
    private String severity;
    private String cppCheckId;
    private String message;
    private String verbose = null;
    private boolean inconclusive = false;

    @Exported
    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameNotNull() {
        return this.fileName != null ? this.fileName : "";
    }

    public void setFileName(String filename) {
        this.fileName = filename;
    }

    @Exported
    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLineNumberString() {
        return "".equals(this.getFileNameNotNull()) ? "" : String.valueOf(this.lineNumber);
    }

    public int getLinkLineNumber() {
        return Math.max(1, this.lineNumber - 10);
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Exported
    public String getCppCheckId() {
        return this.cppCheckId;
    }

    public void setCppCheckId(String cppCheckId) {
        this.cppCheckId = cppCheckId;
    }

    @Exported
    public String getMessage() {
        return this.message;
    }

    public String getMessageHtml() {
        return StringEscapeUtils.escapeHtml((String)this.message);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Exported
    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    @Exported
    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    @Exported
    public String getVerbose() {
        return this.verbose;
    }

    public String getVerboseHtml() {
        return StringEscapeUtils.escapeHtml((String)this.verbose);
    }

    public void setVerbose(String verbose) {
        this.verbose = verbose;
    }

    @Exported
    public boolean isInconclusive() {
        return this.inconclusive;
    }

    public void setInconclusive(boolean inconclusive) {
        this.inconclusive = inconclusive;
    }

    public String getDisplayName() {
        return "cppcheckFile";
    }
}

