/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.graph;

import hudson.model.Run;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class CppcheckGraph
extends Graph {
    private final String yLabel;
    private final CategoryDataset categoryDataset;
    public static final int DEFAULT_CHART_WIDTH = 500;
    public static final int DEFAULT_CHART_HEIGHT = 200;
    private static final Color RED = new Color(0xCC0000);
    private static final Color BLUE = new Color(3433892);
    private static final Color GREEN = new Color(7590422);
    private static final Color YELLOW = new Color(15586304);
    private static final Color BROWN = new Color(12089088);
    private static final Color GRAY = new Color(0x4D4D4D);
    private static final Color VIOLET = new Color(10494192);
    private static final Color PINK = new Color(16750464);
    private static final List<Color> colors = Collections.unmodifiableList(Arrays.asList(RED, BLUE, GREEN, YELLOW, BROWN, GRAY, VIOLET, PINK));

    public CppcheckGraph(Run<?, ?> owner, CategoryDataset categoryDataset, String yLabel, int chartWidth, int chartHeight) {
        super(owner.getTimestamp(), chartWidth, chartHeight);
        this.yLabel = yLabel;
        this.categoryDataset = categoryDataset;
    }

    protected JFreeChart createGraph() {
        JFreeChart chart = ChartFactory.createLineChart(null, null, (String)this.yLabel, (CategoryDataset)this.categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLowerBound(0.0);
        rangeAxis.setAutoRange(true);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(2.0f));
        this.applyColorPalette(renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private void applyColorPalette(LineAndShapeRenderer renderer) {
        int n = 0;
        for (Color c : colors) {
            renderer.setSeriesPaint(n++, (Paint)c);
        }
    }
}

