/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckWorkspaceFile;
import de.java2html.converter.JavaSource2HTMLConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.JavaSourceConversionOptions;
import hudson.model.Run;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringEscapeUtils;

public class CppcheckSource
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int SOURCE_GENERATOR_OFFSET = 13;
    private static final String MESSAGE_COLOR = "#FCAF3E";
    private final transient Run<?, ?> owner;
    private final CppcheckWorkspaceFile cppcheckWorkspaceFile;
    private String sourceCode = "";

    public CppcheckSource(Run<?, ?> owner, CppcheckWorkspaceFile cppcheckWorkspaceFile) {
        this.owner = owner;
        this.cppcheckWorkspaceFile = cppcheckWorkspaceFile;
        this.buildFileContent();
    }

    /*
     * Loose catch block
     */
    private void buildFileContent() {
        block8: {
            FileInputStream is = null;
            try {
                File tempFile = new File(this.cppcheckWorkspaceFile.getTempName(this.owner));
                if (!tempFile.exists()) {
                    throw new IOException("File doesn't exist: " + tempFile.getAbsoluteFile());
                }
                is = new FileInputStream(tempFile);
                this.splitSourceFile(this.highlightSource(is));
                IOUtils.closeQuietly((InputStream)is);
            }
            catch (IOException exception) {
                this.sourceCode = "Can't read file: " + exception.getLocalizedMessage();
            }
            catch (RuntimeException re) {
                this.sourceCode = "Problem for display the source code content: " + re.getLocalizedMessage();
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
    }

    private void splitSourceFile(String sourceFile) {
        int lineNumber;
        StringBuilder output = new StringBuilder(sourceFile.length());
        CppcheckFile cppcheckFile = this.cppcheckWorkspaceFile.getCppcheckFile();
        LineIterator lineIterator = IOUtils.lineIterator((Reader)new StringReader(sourceFile));
        for (lineNumber = 1; lineNumber < 13; ++lineNumber) {
            this.copyLine(output, lineIterator);
        }
        for (lineNumber = 1; lineNumber < cppcheckFile.getLineNumber(); ++lineNumber) {
            this.copyLine(output, lineIterator);
        }
        output.append("</code>\n");
        output.append("</td></tr>\n");
        output.append("<tr><td bgcolor=\"");
        this.appendRangeColor(output);
        output.append("\">\n");
        output.append("<div tooltip=\"");
        this.outputEscaped(output, "<h3>");
        this.outputEscaped(output, cppcheckFile.getCppCheckId());
        output.append(": ");
        this.outputEscaped(output, cppcheckFile.getMessage());
        this.outputEscaped(output, "</h3>");
        if (cppcheckFile.getVerbose() != null) {
            this.outputEscaped(output, "<p style=\"white-space: pre-wrap;\">");
            this.outputEscaped(output, cppcheckFile.getVerbose());
            this.outputEscaped(output, "</p>");
        }
        output.append("\" nodismiss=\"\">\n");
        output.append("<code><b>\n");
        this.copyLine(output, lineIterator);
        ++lineNumber;
        output.append("</b></code>\n");
        output.append("</div>\n");
        output.append("</td></tr>\n");
        output.append("<tr><td>\n");
        output.append("<code>\n");
        while (lineIterator.hasNext()) {
            this.copyLine(output, lineIterator);
        }
        output.append("</code>\n");
        output.append("</td></tr>\n");
        this.sourceCode = output.toString();
    }

    private void outputEscaped(StringBuilder output, String message) {
        output.append(StringEscapeUtils.escapeHtml((String)message));
    }

    private void appendRangeColor(StringBuilder output) {
        output.append(MESSAGE_COLOR);
    }

    private void copyLine(StringBuilder output, LineIterator lineIterator) {
        output.append(lineIterator.nextLine());
        output.append("\n");
    }

    public final String highlightSource(InputStream file) throws IOException {
        JavaSource source = new JavaSourceParser().parse((Reader)new InputStreamReader(file, StandardCharsets.UTF_8));
        JavaSource2HTMLConverter converter = new JavaSource2HTMLConverter();
        StringWriter writer = new StringWriter();
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        options.setShowLineNumbers(true);
        options.setAddLineAnchors(true);
        converter.convert(source, options, (Writer)writer);
        return writer.toString();
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public CppcheckWorkspaceFile getCppcheckWorkspaceFile() {
        return this.cppcheckWorkspaceFile;
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }
}

