/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckBuildAction;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckSource;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckSummary;
import com.thalesgroup.hudson.plugins.cppcheck.config.CppcheckConfig;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckSourceContainer;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckWorkspaceFile;
import hudson.model.AbstractBuild;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.Run;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class CppcheckResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CppcheckReport report;
    private CppcheckSourceContainer cppcheckSourceContainer;
    private transient AbstractBuild<?, ?> owner;

    public CppcheckResult(CppcheckReport report, CppcheckSourceContainer cppcheckSourceContainer, AbstractBuild<?, ?> owner) {
        this.report = report;
        this.cppcheckSourceContainer = cppcheckSourceContainer;
        this.owner = owner;
    }

    public Api getApi() {
        return new Api((Object)this.report);
    }

    @Exported
    public CppcheckReport getReport() {
        return this.report;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public CppcheckSourceContainer getCppcheckSourceContainer() {
        return this.cppcheckSourceContainer;
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) throws IOException {
        if (link.startsWith("source.")) {
            if (!this.owner.getProject().getACL().hasPermission(Item.WORKSPACE)) {
                response.sendRedirect2("nosourcepermission");
                return null;
            }
            Map<Integer, CppcheckWorkspaceFile> agregateMap = this.cppcheckSourceContainer.getInternalMap();
            if (agregateMap != null) {
                CppcheckWorkspaceFile vCppcheckWorkspaceFile = agregateMap.get(Integer.parseInt(StringUtils.substringAfter((String)link, (String)"source.")));
                if (vCppcheckWorkspaceFile == null) {
                    throw new IllegalArgumentException("Error for retrieving the source file with link:" + link);
                }
                return new CppcheckSource((Run<?, ?>)this.owner, vCppcheckWorkspaceFile);
            }
        }
        return null;
    }

    public String getSummary() {
        return CppcheckSummary.createReportSummary(this);
    }

    public String getDetails() {
        return CppcheckSummary.createReportSummaryDetails(this);
    }

    public CppcheckResult getPreviousResult() {
        CppcheckBuildAction previousAction = this.getPreviousAction();
        CppcheckResult previousResult = null;
        if (previousAction != null) {
            previousResult = previousAction.getResult();
        }
        return previousResult;
    }

    private CppcheckBuildAction getPreviousAction() {
        AbstractBuild previousBuild = this.owner.getPreviousBuild();
        if (previousBuild != null) {
            return (CppcheckBuildAction)previousBuild.getAction(CppcheckBuildAction.class);
        }
        return null;
    }

    public int getNumberNewErrorsFromPreviousBuild() {
        CppcheckResult previousCppcheckResult = this.getPreviousResult();
        if (previousCppcheckResult == null) {
            return 0;
        }
        int diff = this.report.getNumberTotal() - previousCppcheckResult.getReport().getNumberTotal();
        return diff > 0 ? diff : 0;
    }

    public int getNumberErrorsAccordingConfiguration(CppcheckConfig cppecheckConfig, boolean checkNewError) throws IOException {
        if (cppecheckConfig == null) {
            throw new IOException("[ERROR] - The cppcheck configuration file is missing. Could you save again your job configuration.");
        }
        int nbErrors = 0;
        int nbPreviousError = 0;
        CppcheckResult previousResult = this.getPreviousResult();
        if (cppecheckConfig.getConfigSeverityEvaluation().isSeverityPossibleError()) {
            nbErrors = this.getReport().getPossibleErrorSeverities().size();
            if (previousResult != null) {
                nbPreviousError = previousResult.getReport().getPossibleErrorSeverities().size();
            }
        }
        if (cppecheckConfig.getConfigSeverityEvaluation().isSeverityStyle()) {
            nbErrors += this.getReport().getStyleSeverities().size();
            if (previousResult != null) {
                nbPreviousError += previousResult.getReport().getStyleSeverities().size();
            }
        }
        if (cppecheckConfig.getConfigSeverityEvaluation().isSeverityPossibleStyle()) {
            nbErrors += this.getReport().getPossibleStyleSeverities().size();
            if (previousResult != null) {
                nbPreviousError += previousResult.getReport().getPossibleStyleSeverities().size();
            }
        }
        if (cppecheckConfig.getConfigSeverityEvaluation().isSeverityError()) {
            nbErrors += this.getReport().getErrorSeverities().size();
            if (previousResult != null) {
                nbPreviousError += previousResult.getReport().getErrorSeverities().size();
            }
        }
        if (checkNewError) {
            if (previousResult != null) {
                return nbErrors - nbPreviousError;
            }
            return 0;
        }
        return nbErrors;
    }
}

