/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.parser.CppcheckParser;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckLogger;
import hudson.FilePath;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import jenkins.security.Roles;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class CppcheckParserResult
implements FilePath.FileCallable<CppcheckReport> {
    private static final long serialVersionUID = 1L;
    private final BuildListener listener;
    private final String cppcheckReportPattern;
    private final boolean ignoreBlankFiles;
    public static final String DELAULT_REPORT_MAVEN = "**/cppcheck-result.xml";

    public CppcheckParserResult(BuildListener listener, String cppcheckReportPattern, boolean ignoreBlankFiles) {
        if (cppcheckReportPattern == null) {
            cppcheckReportPattern = DELAULT_REPORT_MAVEN;
        }
        if (cppcheckReportPattern.trim().length() == 0) {
            cppcheckReportPattern = DELAULT_REPORT_MAVEN;
        }
        this.listener = listener;
        this.cppcheckReportPattern = cppcheckReportPattern;
        this.ignoreBlankFiles = ignoreBlankFiles;
    }

    public CppcheckReport invoke(File basedir, VirtualChannel channel) throws IOException {
        CppcheckReport cppcheckReportResult = new CppcheckReport();
        try {
            String[] cppcheckReportFiles = this.findCppcheckReports(basedir);
            if (cppcheckReportFiles.length == 0) {
                String msg = "No cppcheck test report file(s) were found with the pattern '" + this.cppcheckReportPattern + "' relative to '" + basedir + "'.  Did you enter a pattern relative to the correct directory?  Did you generate the XML report(s) for Cppcheck?";
                throw new IllegalArgumentException(msg);
            }
            CppcheckLogger.log(this.listener, "Processing " + cppcheckReportFiles.length + " files with the pattern '" + this.cppcheckReportPattern + "'.");
            for (String cppchecReportkFileName : cppcheckReportFiles) {
                CppcheckReport cppcheckReport = new CppcheckParser().parse(new File(basedir, cppchecReportkFileName));
                CppcheckParserResult.mergeReport(cppcheckReportResult, cppcheckReport);
            }
        }
        catch (Exception e) {
            CppcheckLogger.log(this.listener, "Parsing throws exceptions. " + e.getMessage());
            return null;
        }
        return cppcheckReportResult;
    }

    private static void mergeReport(CppcheckReport cppcheckReportResult, CppcheckReport cppcheckReport) {
        cppcheckReportResult.getPossibleErrorSeverities().addAll(cppcheckReport.getPossibleErrorSeverities());
        cppcheckReportResult.getPossibleStyleSeverities().addAll(cppcheckReport.getPossibleStyleSeverities());
        cppcheckReportResult.getErrorSeverities().addAll(cppcheckReport.getErrorSeverities());
        cppcheckReportResult.getEverySeverities().addAll(cppcheckReport.getEverySeverities());
        cppcheckReportResult.getNoCategorySeverities().addAll(cppcheckReport.getNoCategorySeverities());
        cppcheckReportResult.getStyleSeverities().addAll(cppcheckReport.getStyleSeverities());
    }

    private String[] findCppcheckReports(File parentPath) {
        FileSet fs = Util.createFileSet((File)parentPath, (String)this.cppcheckReportPattern);
        if (this.ignoreBlankFiles) {
            fs.add(new FileSelector(){

                public boolean isSelected(File basedir, String filename, File file) throws BuildException {
                    return file != null && file.length() != 0L;
                }
            });
        }
        DirectoryScanner ds = fs.getDirectoryScanner();
        return ds.getIncludedFiles();
    }

    public String getCppcheckReportPattern() {
        return this.cppcheckReportPattern;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }
}

