/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.CppcheckResult;
import com.thalesgroup.hudson.plugins.cppcheck.config.CppcheckConfig;
import com.thalesgroup.hudson.plugins.cppcheck.config.CppcheckConfigGraph;
import com.thalesgroup.hudson.plugins.cppcheck.graph.CppcheckGraph;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckSourceContainer;
import com.thalesgroup.hudson.plugins.cppcheck.util.AbstractCppcheckBuildAction;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckBuildHealthEvaluator;
import hudson.model.HealthReport;
import hudson.model.Run;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import org.jenkinsci.plugins.cppcheck.config.CppcheckConfigSeverityEvaluation;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CppcheckBuildAction
extends AbstractCppcheckBuildAction {
    public static final String URL_NAME = "cppcheckResult";
    private CppcheckResult result;
    private CppcheckConfig cppcheckConfig;
    @Deprecated
    private transient Run<?, ?> build;

    public CppcheckBuildAction(Run<?, ?> owner, CppcheckResult result, CppcheckConfig cppcheckConfig) {
        super(owner);
        this.result = result;
        this.cppcheckConfig = cppcheckConfig;
    }

    public String getIconFileName() {
        return "/plugin/cppcheck/icons/cppcheck-24.png";
    }

    public String getDisplayName() {
        return "Cppcheck Result";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public CppcheckResult getResult() {
        return this.result;
    }

    Run<?, ?> getBuild() {
        return this.owner;
    }

    public Object getTarget() {
        return this.result;
    }

    public HealthReport getBuildHealth() {
        try {
            return new CppcheckBuildHealthEvaluator().evaluatBuildHealth(this.cppcheckConfig, this.result.getNumberErrorsAccordingConfiguration(this.cppcheckConfig, false));
        }
        catch (IOException ioe) {
            return new HealthReport();
        }
    }

    private DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> getDataSetBuilder() {
        DataSetBuilder dsb = new DataSetBuilder();
        for (CppcheckBuildAction a = this; a != null; a = (CppcheckBuildAction)((Object)a.getPreviousResult())) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.owner);
            CppcheckReport report = a.getResult().getReport();
            CppcheckConfigGraph configGraph = this.cppcheckConfig.getConfigGraph();
            if (configGraph.isDisplaySeverityStyle()) {
                dsb.add((Number)report.getNumberSeverityStyle(), (Comparable)((Object)"Severity 'style'"), (Comparable)label);
            }
            if (configGraph.isDisplaySeverityPossibleStyle()) {
                dsb.add((Number)report.getNumberSeverityPossibleStyle(), (Comparable)((Object)"Severity 'possibe style'"), (Comparable)label);
            }
            if (configGraph.isDisplaySeverityPossibleError()) {
                dsb.add((Number)report.getNumberSeverityPossibleError(), (Comparable)((Object)"Severity 'possible error'"), (Comparable)label);
            }
            if (configGraph.isDisplaySeverityError()) {
                dsb.add((Number)report.getNumberSeverityError(), (Comparable)((Object)"Severity 'error'"), (Comparable)label);
            }
            if (!configGraph.isDiplayAllError()) continue;
            dsb.add((Number)report.getNumberTotal(), (Comparable)((Object)"All errors"), (Comparable)label);
        }
        return dsb;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar timestamp = this.getBuild().getTimestamp();
        if (req.checkIfModified(timestamp, rsp)) {
            return;
        }
        CppcheckGraph g = new CppcheckGraph(this.getOwner(), this.getDataSetBuilder().build(), "Number of error", this.cppcheckConfig.getConfigGraph().getXSize(), this.cppcheckConfig.getConfigGraph().getYSize());
        g.doPng(req, rsp);
    }

    private Object readResolve() {
        if (this.build != null) {
            this.owner = this.build;
        }
        CppcheckReport report = this.result.getReport();
        org.jenkinsci.plugins.cppcheck.CppcheckReport newReport = new org.jenkinsci.plugins.cppcheck.CppcheckReport();
        if (report != null) {
            newReport.setAllErrors(report.getEverySeverities());
            newReport.setErrorSeverityList(report.getErrorSeverities());
            newReport.setWarningSeverityList(report.getPossibleErrorSeverities());
            newReport.setStyleSeverityList(report.getStyleSeverities());
            newReport.setPerformanceSeverityList(report.getPossibleStyleSeverities());
            newReport.setInformationSeverityList(report.getNoCategorySeverities());
            newReport.setNoCategorySeverityList(new ArrayList<CppcheckFile>());
            newReport.setPortabilitySeverityList(new ArrayList<CppcheckFile>());
        }
        CppcheckSourceContainer sourceContainer = this.result.getCppcheckSourceContainer();
        org.jenkinsci.plugins.cppcheck.CppcheckSourceContainer newSourceContainer = new org.jenkinsci.plugins.cppcheck.CppcheckSourceContainer(sourceContainer.getInternalMap());
        org.jenkinsci.plugins.cppcheck.CppcheckResult newResult = new org.jenkinsci.plugins.cppcheck.CppcheckResult(newReport, newSourceContainer, this.getOwner());
        org.jenkinsci.plugins.cppcheck.config.CppcheckConfig newConfig = new org.jenkinsci.plugins.cppcheck.config.CppcheckConfig();
        newConfig.setPattern(this.cppcheckConfig.getCppcheckReportPattern());
        newConfig.setIgnoreBlankFiles(this.cppcheckConfig.isIgnoreBlankFiles());
        CppcheckConfigSeverityEvaluation configSeverityEvaluation = new CppcheckConfigSeverityEvaluation(this.cppcheckConfig.getConfigSeverityEvaluation().getThreshold(), this.cppcheckConfig.getConfigSeverityEvaluation().getNewThreshold(), this.cppcheckConfig.getConfigSeverityEvaluation().getFailureThreshold(), this.cppcheckConfig.getConfigSeverityEvaluation().getNewFailureThreshold(), this.cppcheckConfig.getConfigSeverityEvaluation().getHealthy(), this.cppcheckConfig.getConfigSeverityEvaluation().getUnHealthy(), this.cppcheckConfig.getConfigSeverityEvaluation().isSeverityError(), this.cppcheckConfig.getConfigSeverityEvaluation().isSeverityPossibleError(), this.cppcheckConfig.getConfigSeverityEvaluation().isSeverityStyle(), this.cppcheckConfig.getConfigSeverityEvaluation().isSeverityPossibleStyle(), true, true, true);
        newConfig.setConfigSeverityEvaluation(configSeverityEvaluation);
        org.jenkinsci.plugins.cppcheck.config.CppcheckConfigGraph configGraph = new org.jenkinsci.plugins.cppcheck.config.CppcheckConfigGraph(this.cppcheckConfig.getConfigGraph().getXSize(), this.cppcheckConfig.getConfigGraph().getYSize(), 0, this.cppcheckConfig.getConfigGraph().isDiplayAllError(), this.cppcheckConfig.getConfigGraph().isDisplaySeverityError(), this.cppcheckConfig.getConfigGraph().isDisplaySeverityPossibleError(), this.cppcheckConfig.getConfigGraph().isDisplaySeverityStyle(), this.cppcheckConfig.getConfigGraph().isDisplaySeverityPossibleStyle(), true, true, true);
        newConfig.setConfigGraph(configGraph);
        return new org.jenkinsci.plugins.cppcheck.CppcheckBuildAction(this.owner, newResult, newConfig, 100);
    }
}

