/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot;

import hudson.model.Hudson;

public class Pagination {
    private static final long serialVersionUID = 116765475669773985L;
    private int totalCount = 0;
    private int currentPage = 1;
    private int prevPage = 0;
    private int nextPage = 0;
    private int totalPage = 0;
    private int count = 0;
    private int pageSize = 10;
    private final String moveLink;
    private String rootUrl = "";

    public Pagination(int currentPage, int totalCount, int pagingSize, String moveLink) {
        this.currentPage = currentPage;
        this.totalCount = totalCount;
        this.pageSize = pagingSize;
        this.moveLink = moveLink;
        try {
            this.rootUrl = Hudson.getInstance().getRootUrlFromRequest();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getTag() {
        if (this.pageSize == 0) {
            this.pageSize = 10;
        }
        this.setPageNation();
        StringBuilder sb = new StringBuilder();
        sb.append("<table summary='page navigation' class='Nnavi'>\n").append("<tr>\n");
        if (this.prevPage + 1 > 10) {
            this.setPrePage(sb);
        } else {
            this.setBlankTd(sb);
        }
        this.setIndex(sb);
        if (this.totalPage > this.prevPage + 10) {
            this.setNextPage(sb);
        }
        sb.append("</tr>\n").append("</table>\n");
        return sb.toString();
    }

    private void setNextPage(StringBuilder sb) {
        sb.append("<td nowrap class='pgR' style='border-right:0px'>\n").append("<a href='").append(this.moveLink).append(this.nextPage).append("'>\n").append("Next").append("<img src='").append(this.rootUrl).append("/plugin/covcomplplot/icons/nextbutton.gif' width='3' height='5' alt='' border='0'>\n").append("</a>\n");
        sb.append("</td>");
    }

    private void setPrePage(StringBuilder sb) {
        sb.append("<td nowrap class='pgR'>\n").append("<a href='").append(this.moveLink).append(this.prevPage).append("'>\n").append("<img src='").append(this.rootUrl).append("/plugin/covcomplplot/icons/nextbutton.gif' width='3' height='5' alt='' border='0'>\n").append("Prev").append("</a>\n");
        sb.append("</td>");
    }

    private void setBlankTd(StringBuilder sb) {
        sb.append("<td class='pgR'>\n");
        sb.append("</td>");
    }

    private void setIndex(StringBuilder sb) {
        this.count = this.prevPage + 1;
        while (this.count < this.nextPage && this.count <= this.totalPage) {
            sb.append("<td");
            if (this.count == this.currentPage) {
                sb.append(" class='on'>\n");
                sb.append("<a href='#'>").append(this.count).append("</a>\n");
            } else {
                sb.append(">\n");
                sb.append("<a href='").append(this.moveLink).append(this.count).append("'>").append(this.count).append("</a>\n");
            }
            sb.append("</td>\n");
            ++this.count;
        }
    }

    private void setPageNation() {
        int current = (this.currentPage - 1) / 10 + 1;
        this.prevPage = (current - 1) * 10;
        this.nextPage = current * 10 + 1;
        this.totalPage = (this.totalCount - 1) / this.pageSize + 1;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

