/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.couchstats;

import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.http.HttpClient;
import org.ektorp.http.StdHttpClient;
import org.ektorp.impl.StdCouchDbConnector;
import org.ektorp.impl.StdCouchDbInstance;
import org.jenkinsci.plugins.couchstats.CouchStatsConfig;
import org.jenkinsci.plugins.couchstats.StatsRecord;
import org.jenkinsci.plugins.couchstats.StatsRecordRepository;
import org.jenkinsci.plugins.couchstats.TimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class CouchStatsListener
extends RunListener<Run> {
    private static final Logger LOGGER = Logger.getLogger(CouchStatsListener.class.getName());

    public void onCompleted(Run r, TaskListener listener) {
        CouchStatsConfig config = CouchStatsConfig.get();
        if (config.getUrl() == null || config.getUrl() == "") {
            LOGGER.log(Level.WARNING, "CouchStats plugin not configured, skipping");
            return;
        }
        String jobName = r.getParent().getFullName().toString();
        String result = r.getResult().toString();
        long duration = r.getDuration();
        long timeInMillis = r.getTimeInMillis();
        String timeString = r.getTimestampString();
        String timeStamp = TimeUtils.timeStamp(timeInMillis);
        LOGGER.log(Level.INFO, "CouchStatsListener: config: " + (Object)((Object)config));
        LOGGER.log(Level.INFO, "CouchStatsListener: job: " + jobName + ", result: " + result + ", duration: " + duration);
        try {
            LOGGER.log(Level.INFO, "Sending stats to " + config.getUrl());
            HttpClient client = new StdHttpClient.Builder().url(config.getUrl()).username(config.getUsername()).password(config.getPassword()).build();
            StdCouchDbInstance instance = new StdCouchDbInstance(client);
            StdCouchDbConnector connector = new StdCouchDbConnector(config.getDocument(), (CouchDbInstance)instance);
            StatsRecord record = new StatsRecord();
            record.setJobName(jobName);
            record.setStatus(result);
            record.setDuration(duration);
            record.setTimeInMillis(timeInMillis);
            record.setTimeString(timeString);
            record.setTimeStamp(timeStamp);
            LOGGER.log(Level.FINE, "Saving build record...");
            StatsRecordRepository repository = new StatsRecordRepository((CouchDbConnector)connector);
            repository.add(record);
            LOGGER.log(Level.FINE, "Saving build record. Done");
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "Unable to configure couchdb connector");
        }
    }
}

