/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.Messages;
import hudson.plugins.copyartifact.SimpleBuildSelectorDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceSelector
extends BuildSelector {
    @Extension(ordinal=-20.0)
    public static final Descriptor<BuildSelector> DESCRIPTOR = new SimpleBuildSelectorDescriptor(WorkspaceSelector.class, Messages._WorkspaceSelector_DisplayName());

    @DataBoundConstructor
    public WorkspaceSelector() {
    }

    @Override
    public boolean isSelectable(Run<?, ?> run, EnvVars env) {
        return true;
    }

    @Override
    protected FilePath getSourceDirectory(Run<?, ?> src, PrintStream console) throws IOException, InterruptedException {
        if (src instanceof AbstractBuild) {
            FilePath srcDir = ((AbstractBuild)src).getWorkspace();
            if (srcDir != null && srcDir.exists()) {
                return srcDir;
            }
            console.println(Messages.CopyArtifact_MissingSrcWorkspace());
            return null;
        }
        return super.getSourceDirectory(src, console);
    }
}

