/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.Extension;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixRun;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.Messages;
import hudson.plugins.copyartifact.SimpleBuildSelectorDescriptor;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggeredBuildSelector
extends BuildSelector {
    private Boolean fallbackToLastSuccessful;
    private final UpstreamFilterStrategy upstreamFilterStrategy;

    @DataBoundConstructor
    public TriggeredBuildSelector(boolean fallback, UpstreamFilterStrategy upstreamFilterStrategy) {
        this.fallbackToLastSuccessful = fallback ? Boolean.TRUE : null;
        this.upstreamFilterStrategy = upstreamFilterStrategy;
    }

    @Deprecated
    public TriggeredBuildSelector(boolean fallback) {
        this(fallback, UpstreamFilterStrategy.UseGlobalSetting);
    }

    public boolean isFallbackToLastSuccessful() {
        return this.fallbackToLastSuccessful != null && this.fallbackToLastSuccessful != false;
    }

    public UpstreamFilterStrategy getUpstreamFilterStrategy() {
        return this.upstreamFilterStrategy;
    }

    public boolean isUseNewest() {
        UpstreamFilterStrategy strategy = this.getUpstreamFilterStrategy();
        if (strategy == null || strategy == UpstreamFilterStrategy.UseGlobalSetting) {
            strategy = ((DescriptorImpl)this.getDescriptor()).getGlobalUpstreamFilterStrategy();
        }
        if (strategy == null) {
            return false;
        }
        switch (strategy) {
            case UseOldest: {
                return false;
            }
            case UseNewest: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Run<?, ?> getBuild(Job<?, ?> job, EnvVars env, BuildFilter filter, Run<?, ?> parent) {
        Run<?, ?> result = null;
        String jobName = job instanceof MatrixConfiguration ? job.getParent().getFullName() : job.getFullName();
        for (Cause cause : parent instanceof MatrixRun ? ((MatrixRun)parent).getParentBuild().getCauses() : parent.getCauses()) {
            if (!(cause instanceof Cause.UpstreamCause)) continue;
            Cause.UpstreamCause upstream = (Cause.UpstreamCause)cause;
            String upstreamProject = upstream.getUpstreamProject();
            int upstreamBuild = upstream.getUpstreamBuild();
            if (jobName.equals(upstreamProject)) {
                Run<?, ?> run = job.getBuildByNumber(upstreamBuild);
                if (run == null || !filter.isSelectable(run, env) || result != null && (!this.isUseNewest() || result.getNumber() >= run.getNumber()) && (this.isUseNewest() || result.getNumber() <= run.getNumber())) continue;
                result = run;
                continue;
            }
            Job parentJob = (Job)Jenkins.getInstance().getItemByFullName(upstreamProject, Job.class);
            Run<?, ?> run = this.getBuild(job, env, filter, parentJob.getBuildByNumber(upstreamBuild));
            if (run == null || !filter.isSelectable(run, env) || result != null && (!this.isUseNewest() || result.getNumber() >= run.getNumber()) && (this.isUseNewest() || result.getNumber() <= run.getNumber())) continue;
            result = run;
        }
        if (result == null && this.isFallbackToLastSuccessful()) {
            result = super.getBuild(job, env, filter, parent);
        }
        return result;
    }

    @Override
    protected boolean isSelectable(Run<?, ?> run, EnvVars env) {
        return this.isFallbackToLastSuccessful() && run.getResult().isBetterOrEqualTo(Result.SUCCESS);
    }

    @Extension(ordinal=25.0)
    public static class DescriptorImpl
    extends SimpleBuildSelectorDescriptor {
        private UpstreamFilterStrategy globalUpstreamFilterStrategy = UpstreamFilterStrategy.UseOldest;

        public DescriptorImpl() {
            super(TriggeredBuildSelector.class, Messages._TriggeredBuildSelector_DisplayName());
            this.load();
        }

        public void setGlobalUpstreamFilterStrategy(UpstreamFilterStrategy globalUpstreamFilterStrategy) {
            this.globalUpstreamFilterStrategy = globalUpstreamFilterStrategy;
        }

        public UpstreamFilterStrategy getGlobalUpstreamFilterStrategy() {
            return this.globalUpstreamFilterStrategy;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.setGlobalUpstreamFilterStrategy(UpstreamFilterStrategy.valueOf(json.getString("globalUpstreamFilterStrategy")));
            this.save();
            return super.configure(req, json);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpstreamFilterStrategy {
        UseGlobalSetting(false, Messages._TriggeredBuildSelector_UpstreamFilterStrategy_UseGlobalSetting()),
        UseOldest(true, Messages._TriggeredBuildSelector_UpstreamFilterStrategy_UseOldest()),
        UseNewest(true, Messages._TriggeredBuildSelector_UpstreamFilterStrategy_UseNewest());

        private final boolean forGlobalSetting;
        private final Localizable displayName;

        private UpstreamFilterStrategy(boolean forGlobalSetting, Localizable displayName) {
            this.forGlobalSetting = forGlobalSetting;
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName.toString();
        }

        public boolean isForGlobalSetting() {
            return this.forGlobalSetting;
        }
    }
}

