/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.copyartifact.Messages;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyArtifactPermissionProperty
extends JobProperty<AbstractProject<?, ?>> {
    public static final String PROPERTY_NAME = "copy-artifact-permission-property";
    private final List<String> projectNameList;

    public List<String> getProjectNameList() {
        return this.projectNameList;
    }

    public String getProjectNames() {
        return StringUtils.join(this.projectNameList, (char)',');
    }

    @DataBoundConstructor
    public CopyArtifactPermissionProperty(String projectNames) {
        List<String> rawProjectNameList = Arrays.asList(projectNames != null ? StringUtils.split((String)projectNames, (char)',') : new String[]{});
        this.projectNameList = new ArrayList<String>(rawProjectNameList.size());
        for (String rawProjectName : rawProjectNameList) {
            if (StringUtils.isBlank((String)rawProjectName)) continue;
            this.projectNameList.add(StringUtils.trim((String)rawProjectName));
        }
    }

    public boolean canCopiedBy(AbstractProject<?, ?> copier) {
        String copierName = copier.getRelativeNameFrom(((AbstractProject)this.owner).getParent());
        String absoluteName = String.format("/%s", copier.getFullName());
        for (String projectName : this.getProjectNameList()) {
            if (!CopyArtifactPermissionProperty.isNameMatch(copierName, projectName) && !CopyArtifactPermissionProperty.isNameMatch(absoluteName, projectName)) continue;
            return true;
        }
        return false;
    }

    static boolean isNameMatch(String name, String pattern) {
        if (pattern == null || name == null) {
            return false;
        }
        if (!pattern.contains("*")) {
            return pattern.equals(name);
        }
        List<String> literals = Arrays.asList(pattern.split("\\*", -1));
        String regex = StringUtils.join((Collection)Lists.transform(literals, (Function)new Function<String, String>(){

            public String apply(String input) {
                return Pattern.quote(input);
            }
        }), (String)".*");
        return name.matches(regex);
    }

    public static boolean canCopyArtifact(AbstractProject<?, ?> copier, AbstractProject<?, ?> copiee) {
        CopyArtifactPermissionProperty prop = (CopyArtifactPermissionProperty)copiee.getProperty(CopyArtifactPermissionProperty.class);
        if (prop == null) {
            return false;
        }
        return prop.canCopiedBy(copier);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return Messages.CopyArtifactPermissionProperty_DisplayName();
        }

        public String getPropertyName() {
            return CopyArtifactPermissionProperty.PROPERTY_NAME;
        }

        public CopyArtifactPermissionProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData == null || formData.isNullObject()) {
                return null;
            }
            JSONObject form = formData.getJSONObject(this.getPropertyName());
            if (form == null || form.isNullObject()) {
                return null;
            }
            return (CopyArtifactPermissionProperty)super.newInstance(req, form);
        }

        List<String> checkNotFoundProjects(String projectNames, ItemGroup<?> context) {
            if (StringUtils.isBlank((String)projectNames)) {
                return Collections.emptyList();
            }
            ArrayList<String> notFound = new ArrayList<String>();
            for (String projectName : StringUtils.split((String)projectNames, (char)',')) {
                AbstractProject proj;
                if (StringUtils.isBlank((String)projectName) || (projectName = StringUtils.trim((String)projectName)).contains("*") || (proj = (AbstractProject)Jenkins.getInstance().getItem(projectName, context, AbstractProject.class)) != null && proj.getRootProject() == proj && proj.hasPermission(Item.READ)) continue;
                notFound.add(projectName);
            }
            return notFound;
        }

        public FormValidation doCheckProjectNames(@QueryParameter String projectNames, @AncestorInPath ItemGroup<?> context) {
            List<String> notFound = this.checkNotFoundProjects(projectNames, context);
            if (!notFound.isEmpty()) {
                return FormValidation.warning((String)Messages.CopyArtifactPermissionProperty_MissingProject(StringUtils.join(notFound, (String)",")));
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteProjectNames(@QueryParameter String value, @AncestorInPath ItemGroup<?> context) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            if (StringUtils.isBlank((String)value)) {
                return candidates;
            }
            value = StringUtils.trim((String)value);
            for (AbstractProject project : Jenkins.getInstance().getAllItems(AbstractProject.class)) {
                String relativeName;
                if (project.getRootProject() != project || !project.hasPermission(Item.READ) || !(relativeName = project.getRelativeNameFrom(context)).startsWith(value)) continue;
                candidates.add(relativeName);
            }
            return candidates;
        }
    }
}

