/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.diagnosis.OldDataMonitor;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.Copier;
import hudson.plugins.copyartifact.CopyArtifactPermissionProperty;
import hudson.plugins.copyartifact.Messages;
import hudson.plugins.copyartifact.ParametersBuildFilter;
import hudson.plugins.copyartifact.StatusBuildSelector;
import hudson.security.ACL;
import hudson.security.SecurityRealm;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyArtifact
extends Builder {
    private static boolean upgradeNeeded = false;
    private static Logger LOGGER = Logger.getLogger(CopyArtifact.class.getName());
    @Deprecated
    private String projectName;
    private String project;
    private String parameters;
    private final String filter;
    private final String target;
    private final String excludes;
    private BuildSelector selector;
    @Deprecated
    private transient Boolean stable;
    private final Boolean flatten;
    private final Boolean optional;
    private final boolean doNotFingerprintArtifacts;

    @Deprecated
    public CopyArtifact(String projectName, String parameters, BuildSelector selector, String filter, String target, boolean flatten, boolean optional) {
        this(projectName, parameters, selector, filter, target, flatten, optional, true);
    }

    @Deprecated
    public CopyArtifact(String projectName, String parameters, BuildSelector selector, String filter, String target, boolean flatten, boolean optional, boolean fingerprintArtifacts) {
        this(projectName, parameters, selector, filter, null, target, flatten, optional, fingerprintArtifacts);
    }

    @DataBoundConstructor
    public CopyArtifact(String projectName, String parameters, BuildSelector selector, String filter, String excludes, String target, boolean flatten, boolean optional, boolean fingerprintArtifacts) {
        AbstractProject p;
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null && (p = (AbstractProject)req.findAncestorObject(AbstractProject.class)) != null) {
            ItemGroup context = p.getParent();
            if (projectName.indexOf(36) < 0 && Jenkins.getInstance().getItem(projectName, context, Job.class) == null) {
                projectName = "";
            }
        }
        this.project = projectName;
        this.parameters = Util.fixEmptyAndTrim((String)parameters);
        this.selector = selector;
        this.filter = Util.fixNull((String)filter).trim();
        this.excludes = Util.fixNull((String)excludes).trim();
        this.target = Util.fixNull((String)target).trim();
        this.flatten = flatten ? Boolean.TRUE : null;
        this.optional = optional ? Boolean.TRUE : null;
        this.doNotFingerprintArtifacts = !fingerprintArtifacts;
    }

    private static synchronized void setUpgradeNeeded() {
        if (!upgradeNeeded) {
            LOGGER.info("Upgrade for Copy Artifact is scheduled.");
            upgradeNeeded = true;
        }
    }

    private static List<CopyArtifact> getCopyArtifactsInProject(AbstractProject<?, ?> project) throws IOException {
        DescribableList list;
        Object object = project instanceof Project ? ((Project)project).getBuildersList() : (list = project instanceof MatrixProject ? ((MatrixProject)project).getBuildersList() : null);
        if (list == null) {
            return Collections.emptyList();
        }
        return list.getAll(CopyArtifact.class);
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void upgradeCopyArtifact() {
        if (!upgradeNeeded) {
            return;
        }
        upgradeNeeded = false;
        boolean isUpgraded = false;
        for (AbstractProject project : Jenkins.getInstance().getAllItems(AbstractProject.class)) {
            try {
                for (CopyArtifact target : CopyArtifact.getCopyArtifactsInProject(project)) {
                    try {
                        if (!target.upgradeIfNecessary(project)) continue;
                        isUpgraded = true;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, String.format("Failed to upgrade CopyArtifact in %s", project.getFullName()), e);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, String.format("Failed to upgrade CopyArtifact in %s", project.getFullName()), e);
            }
        }
        if (!isUpgraded) {
            LOGGER.warning("Update of CopyArtifact is scheduled, but no CopyArtifact to upgrade was found!");
        }
    }

    public String getProjectName() {
        return this.project;
    }

    public String getParameters() {
        return this.parameters;
    }

    public BuildSelector getBuildSelector() {
        return this.selector;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isFlatten() {
        return this.flatten != null && this.flatten != false;
    }

    public boolean isOptional() {
        return this.optional != null && this.optional != false;
    }

    private boolean upgradeIfNecessary(AbstractProject<?, ?> job) throws IOException {
        if (this.isUpgradeNeeded()) {
            int i = this.projectName.lastIndexOf(47);
            if (i != -1 && this.projectName.indexOf(61, i) != -1 && Jenkins.getInstance().getItem(this.projectName, job.getParent(), Job.class) == null) {
                this.project = this.projectName.substring(0, i);
                this.parameters = this.projectName.substring(i + 1);
            } else {
                this.project = this.projectName;
                this.parameters = null;
            }
            LOGGER.log(Level.INFO, "Split {0} into {1} with parameters {2}", new Object[]{this.projectName, this.project, this.parameters});
            this.projectName = null;
            job.save();
            return true;
        }
        return false;
    }

    private boolean isUpgradeNeeded() {
        return this.projectName != null;
    }

    public boolean isFingerprintArtifacts() {
        return !this.doNotFingerprintArtifacts;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.upgradeIfNecessary(build.getProject());
        PrintStream console = listener.getLogger();
        String expandedProject = this.project;
        String expandedFilter = this.filter;
        String expandedExcludes = this.getExcludes();
        try {
            FilePath targetDir;
            EnvVars env = build.getEnvironment((TaskListener)listener);
            env.overrideAll(build.getBuildVariables());
            expandedProject = env.expand(this.project);
            Job job = (Job)Jenkins.getInstance().getItem(expandedProject, build.getProject().getRootProject().getParent(), Job.class);
            if (job != null && !expandedProject.equals(this.project) && !this.canReadFrom(job, build)) {
                job = null;
            }
            if (job == null) {
                console.println(Messages.CopyArtifact_MissingProject(expandedProject));
                return false;
            }
            Run<?, ?> src = this.selector.getBuild((Job<?, ?>)job, env, this.parameters != null ? new ParametersBuildFilter(env.expand(this.parameters)) : new BuildFilter(), (Run<?, ?>)build);
            if (src == null) {
                console.println(Messages.CopyArtifact_MissingBuild(expandedProject));
                return this.isOptional();
            }
            FilePath baseTargetDir = targetDir = build.getWorkspace();
            if (targetDir == null || !targetDir.exists()) {
                console.println(Messages.CopyArtifact_MissingWorkspace());
                return this.isOptional();
            }
            EnvAction envData = (EnvAction)build.getAction(EnvAction.class);
            if (envData != null) {
                envData.add(this.getItemGroup(build), expandedProject, src.getNumber());
            }
            if (this.target.length() > 0) {
                targetDir = new FilePath(targetDir, env.expand(this.target));
            }
            if ((expandedFilter = env.expand(this.filter)).trim().length() == 0) {
                expandedFilter = "**";
            }
            if (StringUtils.isBlank((String)(expandedExcludes = env.expand(expandedExcludes)))) {
                expandedExcludes = null;
            }
            Copier copier = ((Copier)Jenkins.getInstance().getExtensionList(Copier.class).get(0)).clone();
            if (Hudson.getInstance().getPlugin("maven-plugin") != null && src instanceof MavenModuleSetBuild) {
                boolean ok = this.perform(src, build, expandedFilter, expandedExcludes, targetDir, baseTargetDir, copier, console);
                for (Run r : ((MavenModuleSetBuild)src).getModuleLastBuilds().values()) {
                    ok |= this.perform(r, build, expandedFilter, expandedExcludes, targetDir, baseTargetDir, copier, console);
                }
                return ok;
            }
            if (src instanceof MatrixBuild) {
                boolean ok = false;
                for (MatrixRun r : ((MatrixBuild)src).getExactRuns()) {
                    ok |= this.perform((Run)r, build, expandedFilter, expandedExcludes, targetDir.child(r.getParent().getName()), baseTargetDir, copier, console);
                }
                return ok;
            }
            return this.perform(src, build, expandedFilter, expandedExcludes, targetDir, baseTargetDir, copier, console);
        }
        catch (IOException ex) {
            Util.displayIOException((IOException)ex, (TaskListener)listener);
            ex.printStackTrace(listener.error(Messages.CopyArtifact_FailedToCopy(expandedProject, expandedFilter)));
            return false;
        }
    }

    private boolean canReadFrom(Job<?, ?> job, AbstractBuild<?, ?> build) {
        if (job instanceof AbstractProject && CopyArtifactPermissionProperty.canCopyArtifact(build.getProject().getRootProject(), ((AbstractProject)job).getRootProject())) {
            return true;
        }
        Authentication a = Jenkins.getAuthentication();
        if (!ACL.SYSTEM.equals(a)) {
            boolean b = job.getACL().hasPermission(Item.READ);
            if (!b) {
                LOGGER.fine(String.format("Refusing to copy artifact from %s to %s because %s lacks Item.READ access", job, build, a));
            }
            return b;
        }
        boolean b = job.getACL().hasPermission((Authentication)new UsernamePasswordAuthenticationToken((Object)"authenticated", (Object)"", new GrantedAuthority[]{SecurityRealm.AUTHENTICATED_AUTHORITY}), Item.READ);
        if (!b) {
            LOGGER.fine(String.format("Refusing to copy artifact from %s to %s because 'authenticated' lacks Item.READ access", job, build));
        }
        return b;
    }

    private ItemGroup getItemGroup(AbstractBuild<?, ?> build) {
        ItemGroup group = build.getProject().getParent();
        if (group instanceof Job) {
            return ((Job)group).getParent();
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean perform(Run src, AbstractBuild<?, ?> dst, String expandedFilter, String expandedExcludes, FilePath targetDir, FilePath baseTargetDir, Copier copier, PrintStream console) throws IOException, InterruptedException {
        FilePath srcDir = this.selector.getSourceDirectory(src, console);
        if (srcDir == null) {
            return this.isOptional();
        }
        copier.init(src, dst, srcDir, baseTargetDir);
        try {
            int cnt;
            if (!this.isFlatten()) {
                cnt = copier.copyAll(srcDir, expandedFilter, expandedExcludes, targetDir, this.isFingerprintArtifacts());
            } else {
                FilePath[] list;
                targetDir.mkdirs();
                for (FilePath file : list = srcDir.list(expandedFilter, expandedExcludes, false)) {
                    copier.copyOne(file, new FilePath(targetDir, file.getName()), this.isFingerprintArtifacts());
                }
                cnt = list.length;
            }
            console.println(Messages.CopyArtifact_Copied(cnt, HyperlinkNote.encodeTo((String)('/' + src.getParent().getUrl()), (String)src.getParent().getFullDisplayName()), HyperlinkNote.encodeTo((String)('/' + src.getUrl()), (String)Integer.toString(src.getNumber()))));
            boolean bl = cnt > 0 || this.isOptional();
            return bl;
        }
        finally {
            copier.end();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnvAction
    implements EnvironmentContributingAction {
        private transient Map<String, String> data = new HashMap<String, String>();

        private EnvAction() {
        }

        private void add(ItemGroup ctx, String projectName, int buildNumber) {
            if (this.data == null) {
                return;
            }
            Job item = this.getProject(ctx, projectName);
            projectName = projectName.startsWith("/") ? item.getFullName() : item.getRelativeNameFrom(ctx);
            this.data.put("COPYARTIFACT_BUILD_NUMBER_" + projectName.toUpperCase().replaceAll("[^A-Z]+", "_"), Integer.toString(buildNumber));
        }

        private Job getProject(ItemGroup ctx, String projectPath) {
            String[] parts = projectPath.split("/");
            if (projectPath.startsWith("/")) {
                ctx = Jenkins.getInstance();
            }
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (part.length() == 0) continue;
                if (part.equals("..")) {
                    ctx = ((Item)ctx).getParent();
                    continue;
                }
                Item item = ctx.getItem(part);
                if (item == null && i == 0) {
                    item = Jenkins.getInstance().getItem(part);
                }
                if (item instanceof Job) {
                    return (Job)item;
                }
                ctx = (ItemGroup)item;
            }
            return null;
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            if (this.data != null) {
                env.putAll(this.data);
            }
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class CopyArtifactRunListener
    extends RunListener<Build> {
        public CopyArtifactRunListener() {
            super(Build.class);
        }

        public void onStarted(Build r, TaskListener listener) {
            if (((Project)r.getProject()).getBuildersList().get(CopyArtifact.class) != null) {
                r.addAction((Action)new EnvAction());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class ListenerImpl
    extends ItemListener {
        public void onRenamed(Item item, String oldName, String newName) {
            String oldFullName = Items.getCanonicalName((ItemGroup)item.getParent(), (String)oldName);
            String newFullName = Items.getCanonicalName((ItemGroup)item.getParent(), (String)newName);
            for (AbstractProject project : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                try {
                    for (CopyArtifact ca : ListenerImpl.getCopiers(project)) {
                        ItemGroup context;
                        String newProjectName;
                        String projectName = ca.getProjectName();
                        String suffix = "";
                        int i = projectName.indexOf(61);
                        if (i > 0) {
                            int end = projectName.substring(0, i).lastIndexOf(47);
                            suffix = projectName.substring(end);
                            projectName = projectName.substring(0, end);
                        }
                        if (projectName.equals(newProjectName = Items.computeRelativeNamesAfterRenaming((String)oldFullName, (String)newFullName, (String)projectName, (ItemGroup)(context = project.getParent())))) continue;
                        ca.project = newProjectName + suffix;
                        project.save();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(ListenerImpl.class.getName()).log(Level.WARNING, "Failed to resave project " + project.getName() + " for project rename in CopyArtifact build step (" + oldName + " =>" + newName + ")", ex);
                }
            }
        }

        private static List<CopyArtifact> getCopiers(AbstractProject<?, ?> project) throws IOException {
            List copiers = CopyArtifact.getCopyArtifactsInProject(project);
            for (CopyArtifact copier : copiers) {
                copier.upgradeIfNecessary(project);
            }
            return copiers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckProjectName(@AncestorInPath AbstractProject anc, @QueryParameter String value) {
            if (!anc.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            Item item = Jenkins.getInstance().getItem(value, anc.getParent());
            FormValidation result = item != null ? (Hudson.getInstance().getPlugin("maven-plugin") != null && item instanceof MavenModuleSet ? FormValidation.warning((String)Messages.CopyArtifact_MavenProject()) : (item instanceof MatrixProject ? FormValidation.warning((String)Messages.CopyArtifact_MatrixProject()) : FormValidation.ok())) : (value.indexOf(36) >= 0 ? FormValidation.warning((String)Messages.CopyArtifact_ParameterizedName()) : FormValidation.error((String)hudson.tasks.Messages.BuildTrigger_NoSuchProject((Object)value, (Object)AbstractProject.findNearest((String)value).getName())));
            return result;
        }

        public boolean isApplicable(Class<? extends AbstractProject> clazz) {
            return true;
        }

        public String getDisplayName() {
            return Messages.CopyArtifact_DisplayName();
        }

        public DescriptorExtensionList<BuildSelector, Descriptor<BuildSelector>> getBuildSelectors() {
            return Hudson.getInstance().getDescriptorList(BuildSelector.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConverterImpl
    extends XStream2.PassthruConverter<CopyArtifact> {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }

        protected void callback(CopyArtifact obj, UnmarshallingContext context) {
            if (obj.selector == null) {
                obj.selector = new StatusBuildSelector(obj.stable != null && obj.stable != false);
                OldDataMonitor.report((UnmarshallingContext)context, (String)"1.355");
            }
            if (obj.isUpgradeNeeded()) {
                CopyArtifact.setUpgradeNeeded();
            }
        }
    }
}

