/*
 * Decompiled with CFR 0.152.
 */
package com.aspectsecurity.contrast.contrastjenkins.plots;

import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityFrequencyAction;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.util.Graph;
import hudson.util.RunList;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class VulnerabilityFrequencyPlot
extends Graph {
    private AbstractProject<?, ?> project;

    public VulnerabilityFrequencyPlot(AbstractProject<?, ?> project) {
        super(Calendar.getInstance(), 500, 200);
        this.project = project;
    }

    protected JFreeChart createGraph() {
        DefaultCategoryDataset dataset = this.createVulnerabilityFrequencyDataset();
        JFreeChart chart = ChartFactory.createStackedBarChart(null, (String)"Build Number", (String)"Vulnerability Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        this.setColors(renderer);
        plot.setRenderer((CategoryItemRenderer)renderer);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis("Build Number");
        plot.setDomainAxis((CategoryAxis)domainAxis);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRange(true);
        return chart;
    }

    private DefaultCategoryDataset createVulnerabilityFrequencyDataset() {
        ArrayList<VulnerabilityFrequencyAction> actions = new ArrayList<VulnerabilityFrequencyAction>();
        RunList builds = this.project.getBuilds().limit(10);
        for (Run run : builds) {
            VulnerabilityFrequencyAction action = (VulnerabilityFrequencyAction)run.getAction(VulnerabilityFrequencyAction.class);
            if (action == null) continue;
            actions.add(action);
        }
        Collections.reverse(actions);
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        for (VulnerabilityFrequencyAction action : actions) {
            Map<String, Integer> result = action.getResult().getTraceResult();
            for (Map.Entry<String, Integer> entry : result.entrySet()) {
                ds.addValue((Number)entry.getValue(), (Comparable)((Object)entry.getKey()), (Comparable)((Object)Integer.toString(action.getBuildNumber())));
            }
        }
        return ds;
    }

    private List<Color> setColors(BarRenderer renderer) {
        ArrayList<Color> colors = new ArrayList<Color>();
        renderer.setSeriesPaint(0, (Paint)new Color(60, 195, 178));
        renderer.setSeriesPaint(1, (Paint)new Color(174, 205, 67));
        renderer.setSeriesPaint(2, (Paint)new Color(247, 182, 0));
        renderer.setSeriesPaint(3, (Paint)new Color(94, 68, 130));
        renderer.setSeriesPaint(4, (Paint)new Color(247, 138, 49));
        renderer.setSeriesPaint(5, (Paint)new Color(60, 195, 178, 128));
        renderer.setSeriesPaint(6, (Paint)new Color(174, 205, 67, 128));
        renderer.setSeriesPaint(7, (Paint)new Color(247, 182, 0, 128));
        renderer.setSeriesPaint(8, (Paint)new Color(94, 68, 130, 128));
        renderer.setSeriesPaint(9, (Paint)new Color(247, 138, 49, 128));
        renderer.setSeriesPaint(10, (Paint)new Color(49, 67, 78));
        renderer.setSeriesPaint(11, (Paint)new Color(37, 140, 191));
        renderer.setSeriesPaint(12, (Paint)new Color(230, 48, 37));
        renderer.setSeriesPaint(13, (Paint)new Color(49, 67, 78, 128));
        renderer.setSeriesPaint(14, (Paint)new Color(37, 140, 191, 128));
        renderer.setSeriesPaint(15, (Paint)new Color(230, 48, 37, 128));
        return colors;
    }
}

