/*
 * Decompiled with CFR 0.152.
 */
package com.aspectsecurity.contrast.contrastjenkins.plots;

import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityFrequencyAction;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityTrendHelper;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.util.Graph;
import hudson.util.RunList;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class SeverityFrequencyPlot
extends Graph {
    private AbstractProject<?, ?> project;

    public SeverityFrequencyPlot(AbstractProject<?, ?> project) {
        super(Calendar.getInstance(), 500, 200);
        this.project = project;
    }

    protected JFreeChart createGraph() {
        DefaultCategoryDataset dataset = this.createSeverityFrequencyDataset();
        JFreeChart chart = ChartFactory.createStackedBarChart(null, (String)"Build Number", (String)"Severity Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        this.setColors(renderer);
        plot.setRenderer((CategoryItemRenderer)renderer);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis("Build Number");
        plot.setDomainAxis((CategoryAxis)domainAxis);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRange(true);
        return chart;
    }

    private DefaultCategoryDataset createSeverityFrequencyDataset() {
        ArrayList<VulnerabilityFrequencyAction> actions = new ArrayList<VulnerabilityFrequencyAction>();
        RunList builds = this.project.getBuilds().limit(10);
        for (Run run : builds) {
            VulnerabilityFrequencyAction action = (VulnerabilityFrequencyAction)run.getAction(VulnerabilityFrequencyAction.class);
            if (action == null) continue;
            actions.add(action);
        }
        Collections.reverse(actions);
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        for (VulnerabilityFrequencyAction action : actions) {
            Map<String, Integer> result = action.getResult().getSeverityResult();
            String buildNumber = Integer.toString(action.getBuildNumber());
            for (String severity : VulnerabilityTrendHelper.SEVERITIES) {
                ds.addValue((Number)result.get(severity), (Comparable)((Object)severity), (Comparable)((Object)buildNumber));
            }
        }
        return ds;
    }

    private List<Color> setColors(BarRenderer renderer) {
        ArrayList<Color> colors = new ArrayList<Color>();
        renderer.setSeriesPaint(0, (Paint)new Color(232, 232, 232));
        renderer.setSeriesPaint(1, (Paint)new Color(186, 186, 186));
        renderer.setSeriesPaint(2, (Paint)new Color(247, 182, 0));
        renderer.setSeriesPaint(3, (Paint)new Color(247, 138, 49));
        renderer.setSeriesPaint(4, (Paint)new Color(230, 48, 37));
        return colors;
    }
}

