/*
 * Decompiled with CFR 0.152.
 */
package com.aspectsecurity.contrast.contrastjenkins;

import com.aspectsecurity.contrast.contrastjenkins.App;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityType;
import hudson.util.Secret;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class TeamServerProfile {
    private String name;
    private String username;
    private Secret apiKey;
    private Secret serviceKey;
    private String orgUuid;
    private String teamServerUrl;
    private String applicationName;
    private List<VulnerabilityType> vulnerabilityTypes;
    private boolean applyVulnerableBuildResultOnContrastError;
    private String vulnerableBuildResult;
    private boolean allowGlobalThresholdConditionsOverride;
    private List<App> apps;
    @Deprecated
    private boolean failOnWrongApplicationId;
    @Deprecated
    private boolean failOnWrongApplicationName;

    @DataBoundConstructor
    public TeamServerProfile(String name, String username, String apiKey, String serviceKey, String orgUuid, String teamServerUrl, boolean applyVulnerableBuildResultOnContrastError, String vulnerableBuildResult, boolean allowGlobalThresholdConditionsOverride) {
        this.name = name;
        this.username = username;
        this.apiKey = Secret.fromString((String)apiKey);
        this.serviceKey = Secret.fromString((String)serviceKey);
        this.orgUuid = orgUuid;
        this.teamServerUrl = teamServerUrl;
        this.applyVulnerableBuildResultOnContrastError = applyVulnerableBuildResultOnContrastError;
        this.vulnerableBuildResult = vulnerableBuildResult;
        this.allowGlobalThresholdConditionsOverride = allowGlobalThresholdConditionsOverride;
    }

    public Secret getSecretApiKey() {
        return this.apiKey;
    }

    public Secret getSecretServiceKey() {
        return this.serviceKey;
    }

    String getApiKey() {
        return this.apiKey.getPlainText();
    }

    String getServiceKey() {
        return this.serviceKey.getPlainText();
    }

    public boolean isApplyVulnerableBuildResultOnContrastError() {
        if (!this.applyVulnerableBuildResultOnContrastError && (this.isFailOnWrongApplicationId() || this.isFailOnWrongApplicationName())) {
            return true;
        }
        return this.applyVulnerableBuildResultOnContrastError;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setApiKey(Secret apiKey) {
        this.apiKey = apiKey;
    }

    public void setServiceKey(Secret serviceKey) {
        this.serviceKey = serviceKey;
    }

    public void setOrgUuid(String orgUuid) {
        this.orgUuid = orgUuid;
    }

    public void setTeamServerUrl(String teamServerUrl) {
        this.teamServerUrl = teamServerUrl;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setVulnerabilityTypes(List<VulnerabilityType> vulnerabilityTypes) {
        this.vulnerabilityTypes = vulnerabilityTypes;
    }

    public void setApplyVulnerableBuildResultOnContrastError(boolean applyVulnerableBuildResultOnContrastError) {
        this.applyVulnerableBuildResultOnContrastError = applyVulnerableBuildResultOnContrastError;
    }

    public void setVulnerableBuildResult(String vulnerableBuildResult) {
        this.vulnerableBuildResult = vulnerableBuildResult;
    }

    public void setAllowGlobalThresholdConditionsOverride(boolean allowGlobalThresholdConditionsOverride) {
        this.allowGlobalThresholdConditionsOverride = allowGlobalThresholdConditionsOverride;
    }

    public void setApps(List<App> apps) {
        this.apps = apps;
    }

    @Deprecated
    public void setFailOnWrongApplicationId(boolean failOnWrongApplicationId) {
        this.failOnWrongApplicationId = failOnWrongApplicationId;
    }

    @Deprecated
    public void setFailOnWrongApplicationName(boolean failOnWrongApplicationName) {
        this.failOnWrongApplicationName = failOnWrongApplicationName;
    }

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public String getOrgUuid() {
        return this.orgUuid;
    }

    public String getTeamServerUrl() {
        return this.teamServerUrl;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public List<VulnerabilityType> getVulnerabilityTypes() {
        return this.vulnerabilityTypes;
    }

    public String getVulnerableBuildResult() {
        return this.vulnerableBuildResult;
    }

    public boolean isAllowGlobalThresholdConditionsOverride() {
        return this.allowGlobalThresholdConditionsOverride;
    }

    public List<App> getApps() {
        return this.apps;
    }

    @Deprecated
    public boolean isFailOnWrongApplicationId() {
        return this.failOnWrongApplicationId;
    }

    @Deprecated
    public boolean isFailOnWrongApplicationName() {
        return this.failOnWrongApplicationName;
    }
}

