/*
 * Decompiled with CFR 0.152.
 */
package com.aspectsecurity.contrast.contrastjenkins;

import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class GlobalThresholdCondition {
    private String teamServerProfileName;
    private Integer thresholdCount;
    private String thresholdSeverity;
    private String thresholdVulnType;
    private boolean autoRemediated;
    private boolean confirmed;
    private boolean suspicious;
    private boolean notAProblem;
    private boolean remediated;
    private boolean reported;
    private boolean fixed;
    private boolean beingTracked;
    private boolean untracked;

    @DataBoundConstructor
    public GlobalThresholdCondition(String teamServerProfileName, Integer thresholdCount, String thresholdSeverity, String thresholdVulnType, boolean autoRemediated, boolean confirmed, boolean suspicious, boolean notAProblem, boolean remediated, boolean reported, boolean fixed, boolean beingTracked, boolean untracked) {
        this.teamServerProfileName = teamServerProfileName;
        this.thresholdCount = thresholdCount;
        this.thresholdSeverity = thresholdSeverity;
        this.thresholdVulnType = thresholdVulnType;
        this.autoRemediated = autoRemediated;
        this.confirmed = confirmed;
        this.suspicious = suspicious;
        this.notAProblem = notAProblem;
        this.remediated = remediated;
        this.reported = reported;
        this.fixed = fixed;
        this.beingTracked = beingTracked;
        this.untracked = untracked;
    }

    public List<String> getVulnerabilityStatuses() {
        ArrayList<String> status = new ArrayList<String>();
        if (this.autoRemediated) {
            status.add("Auto-Remediated");
        }
        if (this.confirmed) {
            status.add("Confirmed");
        }
        if (this.suspicious) {
            status.add("Suspicious");
        }
        if (this.notAProblem) {
            status.add("NotAProblem");
        }
        if (this.remediated) {
            status.add("Remediated");
        }
        if (this.reported) {
            status.add("Reported");
        }
        if (this.fixed) {
            status.add("Fixed");
        }
        if (this.beingTracked) {
            status.add("Being+Tracked");
        }
        if (this.untracked) {
            status.add("Untracked");
        }
        return status;
    }

    public String getTeamServerProfileName() {
        return this.teamServerProfileName;
    }

    public Integer getThresholdCount() {
        return this.thresholdCount;
    }

    public String getThresholdSeverity() {
        return this.thresholdSeverity;
    }

    public String getThresholdVulnType() {
        return this.thresholdVulnType;
    }

    public boolean isAutoRemediated() {
        return this.autoRemediated;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public boolean isSuspicious() {
        return this.suspicious;
    }

    public boolean isNotAProblem() {
        return this.notAProblem;
    }

    public boolean isRemediated() {
        return this.remediated;
    }

    public boolean isReported() {
        return this.reported;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isBeingTracked() {
        return this.beingTracked;
    }

    public boolean isUntracked() {
        return this.untracked;
    }

    public void setTeamServerProfileName(String teamServerProfileName) {
        this.teamServerProfileName = teamServerProfileName;
    }

    public void setThresholdCount(Integer thresholdCount) {
        this.thresholdCount = thresholdCount;
    }

    public void setThresholdSeverity(String thresholdSeverity) {
        this.thresholdSeverity = thresholdSeverity;
    }

    public void setThresholdVulnType(String thresholdVulnType) {
        this.thresholdVulnType = thresholdVulnType;
    }

    public void setAutoRemediated(boolean autoRemediated) {
        this.autoRemediated = autoRemediated;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public void setSuspicious(boolean suspicious) {
        this.suspicious = suspicious;
    }

    public void setNotAProblem(boolean notAProblem) {
        this.notAProblem = notAProblem;
    }

    public void setRemediated(boolean remediated) {
        this.remediated = remediated;
    }

    public void setReported(boolean reported) {
        this.reported = reported;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public void setBeingTracked(boolean beingTracked) {
        this.beingTracked = beingTracked;
    }

    public void setUntracked(boolean untracked) {
        this.untracked = untracked;
    }
}

