/*
 * Decompiled with CFR 0.152.
 */
package com.aspectsecurity.contrast.contrastjenkins;

import com.aspectsecurity.contrast.contrastjenkins.GlobalThresholdCondition;
import com.aspectsecurity.contrast.contrastjenkins.TeamServerProfile;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityTrendHelper;
import com.contrastsecurity.exceptions.UnauthorizedException;
import com.contrastsecurity.models.Organizations;
import com.contrastsecurity.sdk.ContrastSDK;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Result;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ContrastPluginConfig
extends JobProperty<AbstractProject<?, ?>> {
    @DataBoundConstructor
    public ContrastPluginConfig() {
    }

    public ContrastPluginConfigDescriptor getDescriptor() {
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            return (ContrastPluginConfigDescriptor)instance.getDescriptor(((Object)((Object)this)).getClass());
        }
        return null;
    }

    @Extension
    public static class ContrastPluginConfigDescriptor
    extends JobPropertyDescriptor {
        private CopyOnWriteList<TeamServerProfile> teamServerProfiles = new CopyOnWriteList();
        private CopyOnWriteList<GlobalThresholdCondition> globalThresholdConditions = new CopyOnWriteList();

        public ContrastPluginConfigDescriptor() {
            super(ContrastPluginConfig.class);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            JSONArray array = json.optJSONArray("profile");
            if (array != null) {
                this.teamServerProfiles.replaceBy((Collection)req.bindJSONToList(TeamServerProfile.class, (Object)array));
            } else if (json.keySet().isEmpty()) {
                this.teamServerProfiles = new CopyOnWriteList();
            } else {
                this.teamServerProfiles.replaceBy((Object[])new TeamServerProfile[]{(TeamServerProfile)req.bindJSON(TeamServerProfile.class, json.getJSONObject("profile"))});
            }
            for (TeamServerProfile teamServerProfile : this.teamServerProfiles) {
                ContrastSDK contrastSDK = VulnerabilityTrendHelper.createSDK(teamServerProfile.getUsername(), teamServerProfile.getServiceKey(), teamServerProfile.getApiKey(), teamServerProfile.getTeamServerUrl());
                teamServerProfile.setVulnerabilityTypes(VulnerabilityTrendHelper.saveRules(contrastSDK, teamServerProfile.getOrgUuid()));
                teamServerProfile.setApps(VulnerabilityTrendHelper.saveApplicationIds(contrastSDK, teamServerProfile.getOrgUuid()));
            }
            JSONArray globalThresholdConditionJsonArray = json.optJSONArray("globalThresholdCondition");
            if (globalThresholdConditionJsonArray != null) {
                this.globalThresholdConditions.replaceBy((Collection)req.bindJSONToList(GlobalThresholdCondition.class, (Object)globalThresholdConditionJsonArray));
            } else if (json.keySet().isEmpty()) {
                this.globalThresholdConditions = new CopyOnWriteList();
            } else {
                this.globalThresholdConditions.replaceBy((Object[])new GlobalThresholdCondition[]{(GlobalThresholdCondition)req.bindJSON(GlobalThresholdCondition.class, json.getJSONObject("globalThresholdCondition"))});
            }
            this.save();
            return true;
        }

        public ListBoxModel doFillTeamServerProfileNameItems() {
            return VulnerabilityTrendHelper.getProfileNames();
        }

        public ListBoxModel doFillThresholdVulnTypeItems(@QueryParameter(value="teamServerProfileName") String teamServerProfileName) throws IOException {
            return VulnerabilityTrendHelper.getVulnerabilityTypes(teamServerProfileName);
        }

        public FormValidation doTestTeamServerConnection(@QueryParameter(value="username") String username, @QueryParameter(value="apiKey") Secret apiKey, @QueryParameter(value="serviceKey") Secret serviceKey, @QueryParameter(value="teamServerUrl") String teamServerUrl) throws IOException, ServletException {
            if (StringUtils.isEmpty((String)username)) {
                return FormValidation.error((String)"Connection error: Username cannot be empty.");
            }
            if (StringUtils.isEmpty((String)apiKey.getPlainText())) {
                return FormValidation.error((String)"Connection error: Api Key cannot be empty.");
            }
            if (StringUtils.isEmpty((String)serviceKey.getPlainText())) {
                return FormValidation.error((String)"Connection error: Service Key cannot be empty");
            }
            if (StringUtils.isEmpty((String)teamServerUrl)) {
                return FormValidation.error((String)"Connection error: Contrast URL cannot be empty.");
            }
            if (!teamServerUrl.endsWith("/Contrast/api")) {
                return FormValidation.error((String)"Connection error: Contrast Url does not end with /Contrast/api.");
            }
            try {
                ContrastSDK contrastSDK = VulnerabilityTrendHelper.createSDK(username, serviceKey.getPlainText(), apiKey.getPlainText(), teamServerUrl);
                Organizations organizations = contrastSDK.getProfileDefaultOrganizations();
                if (organizations == null || organizations.getOrganization() == null) {
                    return FormValidation.error((String)"Connection error: No organization found, Check your credentials and URL.");
                }
                ArrayList<FormValidation> validationCollection = new ArrayList<FormValidation>();
                validationCollection.add(FormValidation.ok((String)"Successfully connected to Contrast."));
                if (VulnerabilityTrendHelper.isEnabledJobOutcomePolicyExist(contrastSDK, organizations.getOrganization().getOrgUuid())) {
                    validationCollection.add(FormValidation.warning((String)"Your Contrast administrator has set a policy for vulnerability thresholds. The Contrast policy overrides Jenkins security controls for applications included in both."));
                }
                return FormValidation.aggregate(validationCollection);
            }
            catch (UnauthorizedException | IOException e) {
                return FormValidation.error((String)String.format("Unable to connect to Contrast. %s", e.getMessage()));
            }
        }

        public TeamServerProfile[] getTeamServerProfiles() {
            Object[] profileArray = new TeamServerProfile[this.teamServerProfiles.size()];
            return (TeamServerProfile[])this.teamServerProfiles.toArray(profileArray);
        }

        public GlobalThresholdCondition[] getGlobalThresholdConditions() {
            Object[] globalThresholdConditionArray = new GlobalThresholdCondition[this.globalThresholdConditions.size()];
            return (GlobalThresholdCondition[])this.globalThresholdConditions.toArray(globalThresholdConditionArray);
        }

        public ListBoxModel doFillThresholdSeverityItems() {
            return VulnerabilityTrendHelper.getSeverityListBoxModel();
        }

        public FormValidation doCheckThresholdCount(@QueryParameter String value) {
            block4: {
                if (!value.isEmpty()) {
                    try {
                        int temp = Integer.parseInt(value);
                        if (temp < 0) {
                            return FormValidation.error((String)"Please enter a positive integer.");
                        }
                        break block4;
                    }
                    catch (NumberFormatException e) {
                        return FormValidation.error((String)"Please enter a valid integer.");
                    }
                }
                return FormValidation.error((String)"Please enter a positive integer.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProfileName(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a profile name.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUsername(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a username.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApiKey(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set an API Key.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckServiceKey(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a Service Key.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckThresholdSeverity(@QueryParameter String value) {
            return FormValidation.ok();
        }

        public FormValidation doCheckTeamServerUrl(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a TeamServer Url.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOrgUuid(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set an Organization Uuid.");
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "Contrast Plugin Configuration";
        }

        public ListBoxModel doFillVulnerableBuildResultItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(Result.FAILURE.toString());
            items.add(Result.SUCCESS.toString());
            items.add(Result.UNSTABLE.toString());
            items.add(Result.NOT_BUILT.toString());
            items.add(Result.ABORTED.toString());
            return items;
        }
    }
}

