/*
 * Decompiled with CFR 0.152.
 */
package com.aspectsecurity.contrast.contrastjenkins;

import com.aspectsecurity.contrast.contrastjenkins.TeamServerProfile;
import com.aspectsecurity.contrast.contrastjenkins.VulnerabilityTrendHelper;
import com.contrastsecurity.sdk.ContrastSDK;
import com.google.inject.Inject;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.IOUtils;
import hudson.util.ListBoxModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ContrastAgentStep
extends AbstractStepImpl {
    private String profile;
    private String outputDirectory;
    private String agentType;

    @DataBoundSetter
    public void setProfile(String profile) {
        this.profile = profile;
    }

    @DataBoundSetter
    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @DataBoundSetter
    public void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    @DataBoundConstructor
    public ContrastAgentStep(String profile, String outputDirectory, String agentType) {
        this.profile = profile;
        this.outputDirectory = outputDirectory;
        this.agentType = agentType;
    }

    public ContrastAgentStepDescriptorImpl getDescriptor() {
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            return (ContrastAgentStepDescriptorImpl)instance.getDescriptor(((Object)((Object)this)).getClass());
        }
        return null;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getAgentType() {
        return this.agentType;
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run<?, ?> build;
        @StepContextParameter
        private transient TaskListener taskListener;
        @StepContextParameter
        private transient FilePath filePath;
        @Inject
        private transient ContrastAgentStep step;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void run() throws AbortException {
            byte[] agent;
            String agentFileName = VulnerabilityTrendHelper.getDefaultAgentFileNameFromString(this.step.getAgentType());
            TeamServerProfile teamServerProfile = VulnerabilityTrendHelper.getProfile(this.step.getProfile());
            File agentFile = new File(this.step.getOutputDirectory() + "/" + agentFileName);
            if (teamServerProfile == null) {
                VulnerabilityTrendHelper.logMessage(this.taskListener, "Unable to find TeamServer profile.");
                throw new AbortException("Unable to find TeamServer profile.");
            }
            VulnerabilityTrendHelper.logMessage(this.taskListener, "Building connected to TeamServer with profile " + this.step.getProfile());
            ContrastSDK contrastSDK = VulnerabilityTrendHelper.createSDK(teamServerProfile.getUsername(), teamServerProfile.getServiceKey(), teamServerProfile.getApiKey(), teamServerProfile.getTeamServerUrl());
            VulnerabilityTrendHelper.logMessage(this.taskListener, "Downloading the agent to " + agentFile.getAbsolutePath());
            try {
                agent = contrastSDK.getAgent(VulnerabilityTrendHelper.getAgentTypeFromString(this.step.getAgentType()), teamServerProfile.getOrgUuid());
            }
            catch (Exception e) {
                VulnerabilityTrendHelper.logMessage(this.taskListener, e.getMessage());
                throw new AbortException("Unable to download agent from TeamServer.");
            }
            VulnerabilityTrendHelper.logMessage(this.taskListener, "Saving agent to file.");
            try {
                this.filePath.child(this.step.getOutputDirectory()).mkdirs();
                OutputStream outputStream = null;
                ByteArrayInputStream inputStream = null;
                try {
                    outputStream = this.filePath.child(this.step.getOutputDirectory() + "/" + agentFileName).write();
                    inputStream = new ByteArrayInputStream(agent);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
            catch (Exception e) {
                VulnerabilityTrendHelper.logMessage(this.taskListener, e.getMessage());
                throw new AbortException("Unable to save file to " + this.step.getOutputDirectory() + " The exception message is " + e.getMessage() + " The stack trace is " + Arrays.toString(e.getStackTrace()));
            }
            return null;
        }
    }

    @Extension
    public static class ContrastAgentStepDescriptorImpl
    extends AbstractStepDescriptorImpl {
        public ContrastAgentStepDescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "contrastAgent";
        }

        public String getDisplayName() {
            return "Download latest Contrast agent";
        }

        public ListBoxModel doFillProfileItems() {
            return VulnerabilityTrendHelper.getProfileNames();
        }

        public ListBoxModel doFillAgentTypeItems() {
            return VulnerabilityTrendHelper.getAgentTypeListBoxModel();
        }
    }
}

