/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.consulkv.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Strings
extends StringUtils {
    private static final Logger LOG = LoggerFactory.getLogger(Strings.class);

    private Strings() {
    }

    public static String nvl(String in, String out) {
        if (null == in) {
            return out;
        }
        return in;
    }

    public static String nvlOrEmpty(String in, String out) {
        if (in == null || "".equals(in)) {
            return out;
        }
        return in;
    }

    public static String nvlWithLeftPad(String in, String out, String pad) {
        if (null == in) {
            return out;
        }
        return in + pad;
    }

    public static String encode(String data, String encoding) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(data, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            LOG.error(String.format("There was a problem encoding the data.  %s", uee));
        }
        return encoded;
    }

    public static boolean isEmptyAfterTrim(String in) {
        if (in == null) {
            return true;
        }
        return "".equals(in.trim());
    }

    public static String maybeGetMappedValue(ResourceBundle bundle, String prefix, String key) {
        String out = null;
        if (Strings.isEmptyAfterTrim(key)) {
            return key;
        }
        if (bundle == null || !bundle.containsKey(Strings.nvl(prefix, "") + key)) {
            return key;
        }
        out = bundle.getString(Strings.nvl(prefix, "") + key);
        return out;
    }

    public static List<String> parseRegExGroups(String test, String regEx) {
        ArrayList<String> groups = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(test);
        while (matcher.find()) {
            groups.add(matcher.group().substring(2, matcher.group().length() - 1));
        }
        return groups;
    }

    public static boolean checkPattern(String test, String regExPattern) {
        Pattern pattern = Pattern.compile(regExPattern);
        Matcher matcher = pattern.matcher(test);
        return matcher.matches();
    }

    public static String normalizeStoragekey(String storageKey) {
        return storageKey.replace('.', '_').replace('/', '_');
    }
}

