/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.consulkv.common.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.util.Base64;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.consulkv.ConsulRequest;
import org.jenkinsci.plugins.consulkv.common.DebugMode;
import org.jenkinsci.plugins.consulkv.common.exceptions.ConsulRequestException;

public final class ConsulRequestUtils {
    private ConsulRequestUtils() {
    }

    public static String read(ConsulRequest consulRequest) throws ConsulRequestException {
        HttpGet httpGet = new HttpGet(consulRequest.getUrl());
        CloseableHttpClient httpclient = ConsulRequestUtils.getHttpClient(consulRequest, (HttpRequestBase)httpGet);
        ResponseHandler<String> responseHandler = ConsulRequestUtils.getResponseHandler(consulRequest.getDebugMode(), consulRequest.getLogger());
        String responseBody = null;
        try {
            responseBody = (String)httpclient.execute((HttpUriRequest)httpGet, responseHandler);
        }
        catch (IOException ioe) {
            consulRequest.getLogger().println(ExceptionUtils.getFullStackTrace((Throwable)ioe));
            throw new ConsulRequestException("Consul Request Failed.");
        }
        finally {
            ConsulRequestUtils.closeHttpClient(httpclient, consulRequest);
        }
        return responseBody;
    }

    public static String write(ConsulRequest consulRequest) throws ConsulRequestException {
        HttpPut httpPut = new HttpPut(consulRequest.getUrl());
        CloseableHttpClient httpclient = ConsulRequestUtils.getHttpClient(consulRequest, (HttpRequestBase)httpPut);
        httpPut.addHeader("Content-Type", "plain/text; charset=utf-8");
        httpPut.addHeader("Accept", "application/json; charset=utf-8");
        String responseBody = null;
        try {
            StringEntity input = new StringEntity(consulRequest.getValue());
            httpPut.setEntity((HttpEntity)input);
            ResponseHandler<String> responseHandler = ConsulRequestUtils.getResponseHandler(consulRequest.getDebugMode(), consulRequest.getLogger());
            responseBody = (String)httpclient.execute((HttpUriRequest)httpPut, responseHandler);
        }
        catch (IOException ioe) {
            consulRequest.getLogger().println(ExceptionUtils.getFullStackTrace((Throwable)ioe));
            throw new ConsulRequestException("Consul Request Failed.");
        }
        finally {
            ConsulRequestUtils.closeHttpClient(httpclient, consulRequest);
        }
        return responseBody;
    }

    public static String delete(ConsulRequest consulRequest) throws ConsulRequestException {
        HttpDelete httpDelete = new HttpDelete(consulRequest.getUrl());
        CloseableHttpClient httpclient = ConsulRequestUtils.getHttpClient(consulRequest, (HttpRequestBase)httpDelete);
        httpDelete.addHeader("Content-Type", "plain/text; charset=utf-8");
        httpDelete.addHeader("Accept", "application/json; charset=utf-8");
        ResponseHandler<String> responseHandler = ConsulRequestUtils.getResponseHandler(consulRequest.getDebugMode(), consulRequest.getLogger());
        String responseBody = null;
        try {
            responseBody = (String)httpclient.execute((HttpUriRequest)httpDelete, responseHandler);
        }
        catch (IOException ioe) {
            consulRequest.getLogger().println(ExceptionUtils.getFullStackTrace((Throwable)ioe));
            throw new ConsulRequestException("Consul Request Failed.");
        }
        finally {
            ConsulRequestUtils.closeHttpClient(httpclient, consulRequest);
        }
        return responseBody;
    }

    private static ResponseHandler<String> getResponseHandler(final DebugMode debugMode, final PrintStream logger) {
        ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                int status;
                if (debugMode.equals((Object)DebugMode.ENABLED)) {
                    Header[] headers;
                    logger.println("Response Headers: ");
                    for (Header header : headers = response.getAllHeaders()) {
                        logger.println(String.format("%s=%s", header.getName(), header.getValue()));
                    }
                }
                if ((status = response.getStatusLine().getStatusCode()) >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        return EntityUtils.toString((HttpEntity)entity);
                    }
                } else {
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
                return null;
            }
        };
        return responseHandler;
    }

    private static CloseableHttpClient getHttpClient(ConsulRequest consulRequest, HttpRequestBase httpRequestBase) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(consulRequest.getTimeoutConnect()).setConnectTimeout(consulRequest.getTimeoutConnect()).setConnectionRequestTimeout(consulRequest.getTimeoutResponse()).build();
        httpRequestBase.setConfig(requestConfig);
        return httpclient;
    }

    private static void closeHttpClient(CloseableHttpClient httpclient, ConsulRequest consulRequest) {
        if (httpclient != null) {
            try {
                httpclient.close();
            }
            catch (IOException ioe) {
                consulRequest.getLogger().printf("IO Exception was encountered when closing HTTP client.  %s%n", ioe);
            }
        }
    }

    public static String parseJson(String data, String field) throws IOException {
        List<String> fields = Arrays.asList(field);
        return ConsulRequestUtils.parseJson(data, fields, 0).get(field);
    }

    public static Map<String, String> parseJson(String data, List<String> fields, int index) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = mapper.getJsonFactory();
        JsonParser jsonParser = factory.createParser(data);
        JsonNode jsonObj = (JsonNode)mapper.readTree(jsonParser);
        for (String field : fields) {
            map.put(field, jsonObj.get(index).get(field).toString());
        }
        return map;
    }

    public static String decodeValue(String value) throws UnsupportedEncodingException {
        byte[] valueDecoded = Base64.decodeBase64((String)value);
        return new String(valueDecoded, "UTF-8");
    }
}

