/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.consulkv;

import java.io.PrintStream;
import org.jenkinsci.plugins.consulkv.ConsulRequest;
import org.jenkinsci.plugins.consulkv.common.DebugMode;
import org.jenkinsci.plugins.consulkv.common.RequestMode;
import org.jenkinsci.plugins.consulkv.common.exceptions.ValidationException;
import org.jenkinsci.plugins.consulkv.common.utils.Strings;

public class ConsulRequestFactory {
    private final ConsulRequest consulRequest = new ConsulRequest();

    private ConsulRequestFactory() {
    }

    public static ConsulRequestFactory request() {
        return new ConsulRequestFactory();
    }

    public ConsulRequestFactory withUrl(String url) {
        this.consulRequest.setUrl(url);
        return this;
    }

    public ConsulRequestFactory withValue(String value) {
        this.consulRequest.setValue(value);
        return this;
    }

    public ConsulRequestFactory withTimeoutConnect(int timeoutConnect) {
        this.consulRequest.setTimeoutConnect(timeoutConnect);
        return this;
    }

    public ConsulRequestFactory withTimeoutResponse(int timeoutResponse) {
        this.consulRequest.setTimeoutResponse(timeoutResponse);
        return this;
    }

    public ConsulRequestFactory withLogger(PrintStream logger) {
        this.consulRequest.setLogger(logger);
        return this;
    }

    public ConsulRequestFactory withRequestMode(RequestMode requestMode) {
        this.consulRequest.setRequestMode(requestMode);
        return this;
    }

    public ConsulRequestFactory withDebugMode(DebugMode debugMode) {
        this.consulRequest.setDebugMode(debugMode);
        return this;
    }

    public ConsulRequest build() throws ValidationException {
        this.validate();
        return this.consulRequest;
    }

    private boolean validate() throws ValidationException {
        if (Strings.isBlank((String)this.consulRequest.getUrl())) {
            throw new ValidationException("Empty url");
        }
        if (null == this.consulRequest.getRequestMode()) {
            throw new ValidationException("Null request mode");
        }
        if (null == this.consulRequest.getDebugMode()) {
            throw new ValidationException("Null debug mode");
        }
        if (null == this.consulRequest.getLogger()) {
            throw new ValidationException("Null logger");
        }
        if (0 == this.consulRequest.getTimeoutConnect()) {
            throw new ValidationException("0 connection timeout");
        }
        if (0 == this.consulRequest.getTimeoutResponse()) {
            throw new ValidationException("0 response timeout");
        }
        switch (this.consulRequest.getRequestMode()) {
            case WRITE: {
                if (!Strings.isBlank((String)this.consulRequest.getValue())) break;
                throw new ValidationException("Empty value");
            }
        }
        return true;
    }
}

