/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.consulkv;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import javax.annotation.CheckForNull;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.plugins.consulkv.ConsulRequest;
import org.jenkinsci.plugins.consulkv.ConsulRequestFactory;
import org.jenkinsci.plugins.consulkv.ReadBean;
import org.jenkinsci.plugins.consulkv.common.Constants;
import org.jenkinsci.plugins.consulkv.common.DebugMode;
import org.jenkinsci.plugins.consulkv.common.RequestMode;
import org.jenkinsci.plugins.consulkv.common.exceptions.ConsulRequestException;
import org.jenkinsci.plugins.consulkv.common.exceptions.ValidationException;
import org.jenkinsci.plugins.consulkv.common.utils.ConsulRequestUtils;
import org.jenkinsci.plugins.consulkv.common.utils.Strings;
import org.kohsuke.stapler.DataBoundConstructor;

public class ConsulKVReadWrapper
extends SimpleBuildWrapper {
    protected List<ReadBean> reads;

    @DataBoundConstructor
    public ConsulKVReadWrapper(@CheckForNull List<ReadBean> reads) {
        this.reads = reads;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> run, FilePath filePath, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        for (ReadBean read : this.reads) {
            try {
                if (!read.isIgnoreGlobalSettings()) {
                    read.updateFromGlobalConfiguration();
                    if (Strings.isEmpty((String)read.getHostUrl())) {
                        throw new ConsulRequestException("Global settings host URL was not found.");
                    }
                }
                int timeoutConn = read.getTimeoutConnect() == 0 ? Constants.TIMEOUT_CONNECTION.intValue() : read.getTimeoutConnect();
                int timeoutResp = read.getTimeoutResponse() == 0 ? Constants.TIMEOUT_RESPONSE.intValue() : read.getTimeoutResponse();
                String apiUrl = null;
                apiUrl = Strings.isBlank((String)read.getApiUri()) ? "/v1/kv/" : read.getApiUri();
                String url = read.getHostUrl();
                if (Strings.isBlank((String)read.getAclToken())) {
                    url = url + apiUrl + read.getKey();
                } else if (read.getAclToken().contains("${")) {
                    List<String> tokenKeys;
                    if (read.getDebugMode().equals((Object)DebugMode.ENABLED)) {
                        logger.println("ACL Token=" + read.getAclToken());
                    }
                    if ((tokenKeys = Strings.parseRegExGroups(read.getAclToken(), "(\\$\\{[\\w+-]+\\})")) == null || tokenKeys.isEmpty()) {
                        throw new ValidationException(String.format("Wrapper could not parse build parameter from %s.", read.getAclToken()));
                    }
                    String tokenLocal = (String)run.getEnvironment(listener).get((Object)tokenKeys.get(0));
                    if (read.getDebugMode().equals((Object)DebugMode.ENABLED)) {
                        logger.println("Token to be used=" + tokenLocal);
                    }
                    url = url + apiUrl + read.getKey() + String.format("?token=%s", tokenLocal);
                } else {
                    url = url + apiUrl + read.getKey() + String.format("?token=%s", read.getAclToken());
                }
                if (read.getDebugMode().equals((Object)DebugMode.ENABLED)) {
                    logger.println("Consul READ URL:  " + url.toString());
                }
                ConsulRequest consulRequest = ConsulRequestFactory.request().withUrl(url).withTimeoutConnect(timeoutConn).withTimeoutResponse(timeoutResp).withRequestMode(RequestMode.READ).withDebugMode(read.getDebugMode()).withLogger(logger).build();
                String responseRaw = ConsulRequestUtils.read(consulRequest);
                String value = ConsulRequestUtils.decodeValue(ConsulRequestUtils.parseJson(responseRaw, "Value"));
                read.setEnvKey(Strings.normalizeStoragekey(read.getEnvKey()));
                context.env(read.getEnvKey(), value);
                if (!read.getDebugMode().equals((Object)DebugMode.ENABLED)) continue;
                logger.printf("Raw content:  %s%n", responseRaw);
                logger.println(String.format("Stored ENV variable (k,v):  %s=%s", read.getEnvKey(), context.getEnv().get(read.getEnvKey())));
            }
            catch (IOException ioe) {
                run.setResult(Result.FAILURE);
                listener.fatalError("IO exception was detected:  %s%n", new Object[]{ioe});
            }
            catch (ValidationException ve) {
                run.setResult(Result.FAILURE);
                listener.fatalError("Validation exception was detected:  %s%n", new Object[]{ve});
            }
            catch (ConsulRequestException cre) {
                run.setResult(Result.FAILURE);
                listener.fatalError("Consul request exception was detected:  %s%n", new Object[]{cre});
            }
        }
    }

    protected boolean doTearDown() throws IOException, InterruptedException {
        return true;
    }

    public List<ReadBean> getReads() {
        return this.reads;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "Add Consul K/V Read Config(s)";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

