/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.consulkv;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.consulkv.ConsulRequest;
import org.jenkinsci.plugins.consulkv.ConsulRequestFactory;
import org.jenkinsci.plugins.consulkv.GlobalConsulConfig;
import org.jenkinsci.plugins.consulkv.common.Constants;
import org.jenkinsci.plugins.consulkv.common.DebugMode;
import org.jenkinsci.plugins.consulkv.common.RequestMode;
import org.jenkinsci.plugins.consulkv.common.exceptions.ConsulRequestException;
import org.jenkinsci.plugins.consulkv.common.exceptions.ValidationException;
import org.jenkinsci.plugins.consulkv.common.utils.ConsulRequestUtils;
import org.jenkinsci.plugins.consulkv.common.utils.Strings;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ConsulKVBuilder
extends Builder
implements SimpleBuildStep {
    private static Logger LOGGER = Logger.getLogger(ConsulKVBuilder.class.getName());
    private String hostUrl;
    private String key;
    private String aclToken;
    private String keyValue;
    private String apiUri;
    private String envVarKey;
    private RequestMode requestMode;
    private int timeoutConnection;
    private int timeoutResponse;
    private DebugMode debugMode;
    private boolean ignoreGlobalSettings;

    @Deprecated
    public ConsulKVBuilder(String aclToken, String hostUrl, String key, String keyValue, String apiUri, String envVarKey, RequestMode requestMode, Integer timeoutConnection, Integer timeoutResponse, DebugMode debugMode, boolean ignoreGlobalSettings) {
        this.aclToken = aclToken;
        this.hostUrl = hostUrl;
        this.key = key;
        this.keyValue = keyValue;
        this.apiUri = apiUri;
        this.envVarKey = envVarKey;
        this.requestMode = requestMode;
        this.timeoutConnection = timeoutConnection;
        this.timeoutResponse = timeoutResponse;
        this.debugMode = debugMode;
        this.ignoreGlobalSettings = ignoreGlobalSettings;
    }

    @DataBoundConstructor
    public ConsulKVBuilder(@CheckForNull String hostUrl, @CheckForNull String key) {
        this.hostUrl = hostUrl;
        this.key = key;
    }

    public String getAclToken() {
        return this.aclToken;
    }

    @DataBoundSetter
    public void setAclToken(@CheckForNull String aclToken) {
        this.aclToken = aclToken;
    }

    public String getHostUrl() {
        return this.hostUrl;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    @DataBoundSetter
    public void setKeyValue(@CheckForNull String keyValue) {
        this.keyValue = keyValue;
    }

    public String getApiUri() {
        return this.apiUri;
    }

    @DataBoundSetter
    public void setApiUri(@CheckForNull String apiUri) {
        this.apiUri = apiUri;
    }

    public String getEnvVarKey() {
        return this.envVarKey;
    }

    @DataBoundSetter
    public void setEnvVarKey(@CheckForNull String envVarKey) {
        this.envVarKey = envVarKey;
    }

    public RequestMode getRequestMode() {
        return this.requestMode;
    }

    @DataBoundSetter
    public void setRequestMode(@CheckForNull RequestMode requestMode) {
        this.requestMode = requestMode;
    }

    public int getTimeoutConnection() {
        return this.timeoutConnection;
    }

    @DataBoundSetter
    public void setTimeoutConnection(int timeoutConnection) {
        this.timeoutConnection = timeoutConnection;
    }

    public int getTimeoutResponse() {
        return this.timeoutResponse;
    }

    @DataBoundSetter
    public void setTimeoutResponse(int timeoutResponse) {
        this.timeoutResponse = timeoutResponse;
    }

    public DebugMode getDebugMode() {
        return this.debugMode;
    }

    @DataBoundSetter
    public void setDebugMode(@CheckForNull DebugMode debugMode) {
        this.debugMode = debugMode;
    }

    public boolean isIgnoreGlobalSettings() {
        return this.ignoreGlobalSettings;
    }

    @DataBoundSetter
    public void setIgnoreGlobalSettings(boolean ignoreGlobalSettings) {
        this.ignoreGlobalSettings = ignoreGlobalSettings;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        EnvVars environment = build.getEnvironment(listener);
        try {
            ConsulRequest consulRequest;
            if (!this.ignoreGlobalSettings) {
                this.updateFromGlobalConfiguration();
                if (Strings.isEmpty((String)this.hostUrl)) {
                    throw new ConsulRequestException("Global settings host URL was not found.");
                }
            }
            int timeoutConn = this.timeoutConnection == 0 ? Constants.TIMEOUT_CONNECTION : this.timeoutConnection;
            int timeoutResp = this.timeoutResponse == 0 ? Constants.TIMEOUT_RESPONSE : this.timeoutResponse;
            String expandedUrl = environment.expand(this.hostUrl);
            StringBuilder urlStringBuilder = new StringBuilder(expandedUrl);
            String apiUrl = null;
            if (Strings.isEmpty((String)this.apiUri)) {
                if (this.debugMode.equals((Object)DebugMode.ENABLED)) {
                    logger.println(String.format("Using default API URI:  %s", "/v1/kv/"));
                }
                this.apiUri = "/v1/kv/";
            }
            apiUrl = environment.expand(this.apiUri);
            String responseRaw = null;
            String expandedKey = environment.expand(this.key);
            if (Strings.isEmpty((String)this.aclToken)) {
                urlStringBuilder.append(apiUrl).append(expandedKey);
            } else {
                String expandedToken = environment.expand(this.aclToken);
                String formattedTokenString = String.format("?token=%s", expandedToken);
                urlStringBuilder.append(apiUrl).append(expandedKey).append(formattedTokenString);
            }
            if (this.debugMode.equals((Object)DebugMode.ENABLED)) {
                logger.println("Consul " + this.requestMode.name() + " URL:  " + urlStringBuilder.toString());
            }
            if (this.requestMode.equals((Object)RequestMode.READ)) {
                consulRequest = ConsulRequestFactory.request().withUrl(urlStringBuilder.toString()).withTimeoutConnect(timeoutConn).withTimeoutResponse(timeoutResp).withDebugMode(this.debugMode).withRequestMode(this.requestMode).withLogger(logger).build();
                responseRaw = ConsulRequestUtils.read(consulRequest);
                String value = ConsulRequestUtils.decodeValue(ConsulRequestUtils.parseJson(responseRaw, "Value"));
                logger.println(String.format("Consul K/V pair:  %s=%s", this.key, value));
                String expandedEnvVarKey = environment.expand(this.envVarKey);
                String storageKey = Strings.normalizeStoragekey(expandedEnvVarKey);
                environment.addLine(String.format("%s=%s", storageKey, value));
                logger.println(String.format("Stored ENV variable (k,v):  %s=%s", storageKey, environment.get((Object)storageKey)));
            } else if (this.requestMode.equals((Object)RequestMode.WRITE)) {
                String expandedKeyValue = environment.expand(this.keyValue);
                ConsulRequest consulRequest2 = ConsulRequestFactory.request().withUrl(urlStringBuilder.toString()).withValue(expandedKeyValue).withTimeoutConnect(timeoutConn).withTimeoutResponse(timeoutResp).withDebugMode(this.debugMode).withRequestMode(this.requestMode).withLogger(logger).build();
                responseRaw = ConsulRequestUtils.write(consulRequest2);
            } else {
                consulRequest = ConsulRequestFactory.request().withUrl(urlStringBuilder.toString()).withTimeoutConnect(timeoutConn).withTimeoutResponse(timeoutResp).withDebugMode(this.debugMode).withRequestMode(this.requestMode).withLogger(logger).build();
                responseRaw = ConsulRequestUtils.delete(consulRequest);
            }
            if (this.debugMode.equals((Object)DebugMode.ENABLED)) {
                logger.printf("Raw content:  %s%n", responseRaw);
            }
        }
        catch (IOException ioe) {
            build.setResult(Result.FAILURE);
            listener.fatalError("IO exception was detected:  %s%n", new Object[]{ioe});
        }
        catch (ValidationException ve) {
            build.setResult(Result.FAILURE);
            listener.fatalError("Validation exception was detected:  %s%n", new Object[]{ve});
        }
        catch (ConsulRequestException cre) {
            build.setResult(Result.FAILURE);
            listener.fatalError("Consul request exception was detected:  %s%n", new Object[]{cre});
        }
    }

    private DescriptorImpl getDescriptorImpl() {
        return (DescriptorImpl)this.getDescriptor();
    }

    private void updateFromGlobalConfiguration() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            GlobalConsulConfig.DescriptorImpl globalDescriptor = (GlobalConsulConfig.DescriptorImpl)jenkins.getDescriptor(GlobalConsulConfig.class);
            if (globalDescriptor != null) {
                this.hostUrl = globalDescriptor.getConsulHostUrl();
                this.apiUri = globalDescriptor.getConsulApiUri();
                this.aclToken = globalDescriptor.getConsulAclToken();
                this.timeoutConnection = globalDescriptor.getConsulTimeoutConnection();
                this.timeoutResponse = globalDescriptor.getConsulTimeoutResponse();
                this.debugMode = globalDescriptor.getConsulDebugMode();
            } else {
                LOGGER.warning("Could not load global settings.");
            }
        } else {
            LOGGER.warning("Could not load global settings.");
        }
    }

    public String toString() {
        return "ConsulKVBuilder{hostUrl='" + this.hostUrl + '\'' + ", key='" + this.key + '\'' + ", token='" + this.aclToken + '\'' + ", keyValue='" + this.keyValue + '\'' + ", apiURi='" + this.apiUri + '\'' + ", envVarKey='" + this.envVarKey + '\'' + ", requestMode=" + (Object)((Object)this.requestMode) + ", timeoutConnection=" + this.timeoutConnection + ", timeoutResponse=" + this.timeoutResponse + ", debugMode=" + (Object)((Object)this.debugMode) + ", ignoreGlobalSettings=" + this.ignoreGlobalSettings + '}';
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String key;
        private String hostUrl;
        private String aclToken;
        private String apiUri;
        private int timeoutConnection;
        private int timeoutResponse;
        private DebugMode debugMode;
        private boolean ignoreGlobalSettings;

        public DescriptorImpl() {
            this.load();
        }

        public String getHostUrl() {
            return this.hostUrl;
        }

        public void setHostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
        }

        public String getAclToken() {
            return this.aclToken;
        }

        public void setAclToken(String aclToken) {
            this.aclToken = aclToken;
        }

        public String getApiUri() {
            return this.apiUri;
        }

        public void setApiUri(String apiUri) {
            this.apiUri = apiUri;
        }

        public int getTimeoutConnection() {
            return this.timeoutConnection;
        }

        public void setTimeoutConnection(int timeoutConnection) {
            this.timeoutConnection = timeoutConnection;
        }

        public int getTimeoutResponse() {
            return this.timeoutResponse;
        }

        public void setTimeoutResponse(int timeoutResponse) {
            this.timeoutResponse = timeoutResponse;
        }

        public ListBoxModel doFillRequestModeItems() {
            return RequestMode.getFillItems();
        }

        public ListBoxModel doFillDefaultRequestModeItems() {
            return RequestMode.getFillItems();
        }

        public ListBoxModel doFillDebugModeItems() {
            return DebugMode.getFillItems();
        }

        public ListBoxModel doFillDefaultDebugModeItems() {
            return DebugMode.getFillItems();
        }

        public RequestMode getDefaultRequestMode() {
            return RequestMode.READ;
        }

        public DebugMode getDefaultDebugMode() {
            return DebugMode.DISABLED;
        }

        public boolean isIgnoreGlobalSettings() {
            return this.ignoreGlobalSettings;
        }

        public void setIgnoreGlobalSettings(boolean ignoreGlobalSettings) {
            this.ignoreGlobalSettings = ignoreGlobalSettings;
        }

        public DebugMode getDebugMode() {
            return this.debugMode;
        }

        public void setDebugMode(DebugMode debugMode) {
            this.debugMode = debugMode;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public FormValidation doCheckToken(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"No token specified.  Call will be made without a token.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckHostUrl(@QueryParameter String value) {
            String message = "Please set a Host URL, including protocol, eg: http/https.";
            if (value.length() == 0) {
                return FormValidation.error((String)message);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckKey(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the key for this request.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEnvVarKey(@QueryParameter String value) {
            String message = "Please enter an ENV variable storage key that is only RegEx word characters, and hyphens.";
            if (value.length() == 0) {
                return FormValidation.error((String)message);
            }
            if (value.contains(".") || value.contains("/")) {
                return FormValidation.error((String)message);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApiUri(@QueryParameter String value) {
            String message = "Please set a API URI that begins and ends with a \"/\"., example: /v1/kv/.";
            if (value.length() == 0) {
                return FormValidation.error((String)message);
            }
            if (!Strings.checkPattern(value, "^([\\/]\\w+)+\\/$")) {
                return FormValidation.error((String)"Invalid API URI pattern supplied.");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (!this.ignoreGlobalSettings) {
                this.updateFromGlobalConfiguration();
            }
            req.bindJSON((Object)this, formData);
            this.save();
            return super.configure(req, formData);
        }

        public String getDisplayName() {
            return "Consul K/V Builder";
        }

        private void updateFromGlobalConfiguration() {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins != null) {
                GlobalConsulConfig.DescriptorImpl globalDescriptor = (GlobalConsulConfig.DescriptorImpl)jenkins.getDescriptor(GlobalConsulConfig.class);
                if (globalDescriptor != null) {
                    this.hostUrl = globalDescriptor.getConsulHostUrl();
                    this.apiUri = globalDescriptor.getConsulApiUri();
                    this.aclToken = globalDescriptor.getConsulAclToken();
                    this.timeoutConnection = globalDescriptor.getConsulTimeoutConnection();
                    this.timeoutResponse = globalDescriptor.getConsulTimeoutResponse();
                    this.debugMode = globalDescriptor.getConsulDebugMode();
                } else {
                    LOGGER.warning("Could not load global settings.");
                }
            } else {
                LOGGER.warning("Could not load global settings.");
            }
        }

        public String toString() {
            return "DescriptorImpl{hostUrl='" + this.hostUrl + '\'' + ", aclToken='" + this.aclToken + '\'' + ", apiUri='" + this.apiUri + '\'' + ", timeoutConnection=" + this.timeoutConnection + ", timeoutResponse=" + this.timeoutResponse + ", debugMode=" + (Object)((Object)this.debugMode) + ", ignoreGlobalSettings=" + this.ignoreGlobalSettings + '}';
        }
    }
}

