/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.utils;

import io.jenkins.plugins.exceptions.InvalidNameException;
import java.util.HashSet;

public final class NameUtils {
    private static final String invalidChars = "!@#$%^&*;:\"<>?/\\'`~+={}[],";

    private NameUtils() {
    }

    public static void checkAssetNameRestrictions(String name) throws InvalidNameException {
        if (name == null) {
            throw new InvalidNameException("Asset name cannot be null", "(null)");
        }
        if (name.length() == 0) {
            throw new InvalidNameException("Asset name cannot be blank", "");
        }
        if (name.trim().length() == 0) {
            throw new InvalidNameException("Asset name cannot consist entirely of whitespace", "<" + name + ">");
        }
        if (name.trim().length() != name.length()) {
            throw new InvalidNameException("Asset name cannot have leading or trailing whitespace", "<" + name + ">");
        }
        if (!NameUtils.containsNone(name, invalidChars.toCharArray())) {
            throw new InvalidNameException(name + " contains one or more of following invalid characters: " + invalidChars, name);
        }
    }

    public static void checkNullOrEmpty(String string) throws InvalidNameException {
        if (string == null) {
            throw new InvalidNameException("A value must be provided", "(null)");
        }
        if (string.length() == 0) {
            throw new InvalidNameException("The value provided cannot be blank", "");
        }
        if (string.trim().length() == 0) {
            throw new InvalidNameException("The value provided cannot consist entirely of whitespace", "<" + string + ">");
        }
        if (string.trim().length() != string.length()) {
            throw new InvalidNameException("The value provided cannot have leading or trailing whitespace", "<" + string + ">");
        }
    }

    public static void checkCreatedUsernameRestrictions(String deploymentRunUsername) throws InvalidNameException {
        if (deploymentRunUsername == null) {
            throw new InvalidNameException("Username cannot be null", "(null)");
        }
        if (deploymentRunUsername.length() == 0) {
            throw new InvalidNameException("Username cannot be blank", "");
        }
        if (deploymentRunUsername.trim().length() == 0) {
            throw new InvalidNameException("Username cannot consist entirely of whitespace", "<" + deploymentRunUsername + ">");
        }
        if (deploymentRunUsername.trim().length() != deploymentRunUsername.length()) {
            throw new InvalidNameException("Username cannot have leading or trailing whitespace", "<" + deploymentRunUsername + ">");
        }
        HashSet<String> invalidUsernames = new HashSet<String>();
        invalidUsernames.add("cons3rt");
        invalidUsernames.add("root");
        invalidUsernames.add("admin");
        invalidUsernames.add("administrator");
        if (invalidUsernames.contains(deploymentRunUsername.toLowerCase())) {
            throw new InvalidNameException("You have entered a restricted username: " + deploymentRunUsername, deploymentRunUsername);
        }
    }

    public static void checkDeploymentRunNameRestrictions(String name) throws InvalidNameException {
        if (name == null) {
            throw new InvalidNameException("Deployment run name cannot be null", "(null)");
        }
        if (name.length() == 0) {
            throw new InvalidNameException("Deployment run name cannot be blank", "");
        }
        if (name.trim().length() == 0) {
            throw new InvalidNameException("Deployment run name cannot consist entirely of whitespace", "<" + name + ">");
        }
        if (name.trim().length() != name.length()) {
            throw new InvalidNameException("Deployment run name cannot have leading or trailing whitespace", "<" + name + ">");
        }
        if (!NameUtils.containsNone(name, invalidChars.toCharArray())) {
            throw new InvalidNameException(name + " contains one or more of following invalid characters: " + invalidChars, name);
        }
    }

    private static boolean containsNone(String str, char[] invalidChars) {
        if (str == null || invalidChars == null) {
            return true;
        }
        int strSize = str.length();
        int validSize = invalidChars.length;
        for (int i = 0; i < strSize; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < validSize; ++j) {
                if (invalidChars[j] != ch) continue;
                return false;
            }
        }
        return true;
    }
}

