/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.utils;

import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import hudson.util.Secret;
import io.jenkins.plugins.Cons3rtPublisher;
import io.jenkins.plugins.datatype.DeploymentRunOptions;
import io.jenkins.plugins.datatype.Network;
import io.jenkins.plugins.datatype.RunConfiguration;
import io.jenkins.plugins.utils.SecretSerializer;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpWrapper {
    public static final Logger LOGGER = Logger.getLogger(HttpWrapper.class.getName());
    final String authenticationType;
    final String baseUrl;
    final String username;
    final String token;
    final StandardCertificateCredentials certificate;
    final SSLConnectionSocketFactory context;

    public HttpWrapper(String url, String token, String authenticationType, String username, StandardCertificateCredentials certificate) throws HTTPException {
        this.baseUrl = url;
        this.token = token;
        this.authenticationType = authenticationType;
        this.username = username;
        this.certificate = certificate;
        this.context = this.buildConnectionContext();
    }

    private SSLConnectionSocketFactory buildConnectionContext() throws HTTPException {
        try {
            SSLContext sslContext;
            if (Cons3rtPublisher.isCeritificateAuthentication(this.authenticationType)) {
                sslContext = SSLContexts.custom().loadKeyMaterial(this.certificate.getKeyStore(), this.certificate.getPassword().getPlainText().toCharArray()).loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build();
            } else if (Cons3rtPublisher.isUsernameAuthentication(this.authenticationType)) {
                sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build();
            } else {
                throw new HTTPException("Received unknown authentication type: " + this.authenticationType + " could not construct wrapper.");
            }
            return new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new HTTPException(e.getMessage());
        }
    }

    private void setHeaders(HttpUriRequest request) {
        request.setHeader("token", this.token);
        if (Cons3rtPublisher.isUsernameAuthentication(this.authenticationType)) {
            request.setHeader("username", this.username);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String get(String url) throws HTTPException {
        try (CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.context).build();){
            HttpGet get = new HttpGet(url);
            this.setHeaders((HttpUriRequest)get);
            HttpResponse response = this.executeHttpRequest(client, (HttpUriRequest)get);
            String string = this.processResponse(response);
            return string;
        }
        catch (IOException e) {
            throw new HTTPException("get: caught " + e.getClass().getSimpleName() + " during http post with url parameters", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String putJson(String url, String body) throws HTTPException {
        try (CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.context).build();){
            HttpPut put = new HttpPut(url);
            this.setHeaders((HttpUriRequest)put);
            put.setHeader("Content-Type", "application/json");
            if (body != null) {
                StringEntity entity = new StringEntity(body);
                put.setEntity((HttpEntity)entity);
            }
            HttpResponse response = this.executeHttpRequest(client, (HttpUriRequest)put);
            String string = this.processResponse(response);
            return string;
        }
        catch (IOException e) {
            throw new HTTPException("post: caught " + e.getClass().getSimpleName() + " during http post with url parameters", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String putFile(String url, File filePart) throws HTTPException {
        try (CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.context).build();){
            HttpPut put = new HttpPut(url);
            this.setHeaders((HttpUriRequest)put);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            if (filePart == null) throw new HTTPException("File to be uploaded was not found or does not exist");
            if (!filePart.exists()) throw new HTTPException("File to be uploaded was not found or does not exist");
            builder.addTextBody("filename", filePart.getName());
            builder.addBinaryBody("file", filePart, ContentType.APPLICATION_OCTET_STREAM, filePart.getName());
            HttpEntity entity = builder.build();
            put.setEntity(entity);
            HttpResponse response = this.executeHttpRequest(client, (HttpUriRequest)put);
            String string = this.processResponse(response);
            return string;
        }
        catch (IOException e) {
            throw new HTTPException("post: caught " + e.getClass().getSimpleName() + " during http post with url parameters", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String postFile(String url, File filePart) throws HTTPException {
        try (CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.context).build();){
            HttpPost post = new HttpPost(url);
            this.setHeaders((HttpUriRequest)post);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            if (filePart == null) throw new HTTPException("File to be uploaded was not found or does not exist");
            if (!filePart.exists()) throw new HTTPException("File to be uploaded was not found or does not exist");
            builder.addTextBody("filename", filePart.getName());
            builder.addBinaryBody("file", filePart, ContentType.APPLICATION_OCTET_STREAM, filePart.getName());
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            HttpResponse response = this.executeHttpRequest(client, (HttpUriRequest)post);
            String string = this.processResponse(response);
            return string;
        }
        catch (IOException e) {
            throw new HTTPException("post: caught " + e.getClass().getSimpleName() + " during http post with url parameters", e);
        }
    }

    private HttpResponse executeHttpRequest(CloseableHttpClient client, HttpUriRequest request) throws HTTPException {
        try {
            CloseableHttpResponse response = client.execute(request);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200 && status != 202) {
                LOGGER.log(Level.INFO, "Response code equaled : " + response.getStatusLine());
                String http = EntityUtils.toString((HttpEntity)response.getEntity());
                LOGGER.log(Level.INFO, http);
                throw new HTTPException("Response Code returned did not equal 200 or 202. Response: " + http);
            }
            LOGGER.log(Level.INFO, "Response code equaled : " + response.getStatusLine());
            return response;
        }
        catch (ClientProtocolException e) {
            String message = "executeHttpRequest: caught " + ((Object)((Object)e)).getClass().getSimpleName() + " while attempting to make request. Message: " + e.getMessage();
            LOGGER.log(Level.WARNING, message);
            throw new HTTPException(message);
        }
        catch (IOException e) {
            String message = "executeHttpRequest: caught " + e.getClass().getSimpleName() + " while attempting to make request. Message: " + e.getMessage();
            LOGGER.log(Level.WARNING, message);
            throw new HTTPException(message);
        }
    }

    private String processResponse(HttpResponse response) throws HTTPException {
        try {
            String retval = null;
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                retval = EntityUtils.toString((HttpEntity)responseEntity);
                LOGGER.log(Level.INFO, retval);
            }
            return retval;
        }
        catch (IOException | ParseException e) {
            String message = "processResponse: caught " + e.getClass().getSimpleName() + " while attempting to parse response. Message: " + e.getMessage();
            LOGGER.log(Level.WARNING, message);
            throw new HTTPException(message);
        }
    }

    private JSONObject processJSONObjectFromResponse(HttpResponse response) throws Exception {
        try {
            HttpEntity responseEntity = response.getEntity();
            JSONObject retval = new JSONObject();
            if (responseEntity != null) {
                String returnString = EntityUtils.toString((HttpEntity)responseEntity);
                LOGGER.log(Level.INFO, returnString);
                if (returnString != null && !returnString.isEmpty()) {
                    retval = new JSONObject(returnString);
                }
            }
            return retval;
        }
        catch (Exception e) {
            String message = "processResponse: caught " + e.getClass().getSimpleName() + " while attempting to parse response. Message: " + e.getMessage();
            LOGGER.log(Level.WARNING, message);
            throw new Exception(message);
        }
    }

    public String validateCredentials() throws HTTPException {
        String url = this.baseUrl + "/rest/api/validatecredentials";
        return this.get(url);
    }

    public String createAsset(File file) throws HTTPException {
        String url = this.baseUrl + "/rest/api/import/";
        return this.postFile(url, file);
    }

    public String updateAsset(Integer assetId, File file) throws HTTPException {
        String url = this.baseUrl + "/rest/api/software/" + assetId + "/updatecontent";
        return this.putFile(url, file);
    }

    public Set<Map.Entry<String, Integer>> getProjects() throws HTTPException {
        HashSet<Map.Entry<String, Integer>> retval = new HashSet<Map.Entry<String, Integer>>();
        String url = this.baseUrl + "/rest/api/projects";
        String result = this.get(url);
        if (result != null && !result.isEmpty()) {
            JSONArray projects = new JSONArray(result);
            for (int i = 0; i < projects.length(); ++i) {
                JSONObject rec = projects.getJSONObject(i);
                Integer id = rec.getInt("id");
                String name = rec.getString("name");
                AbstractMap.SimpleEntry<String, Integer> entry = new AbstractMap.SimpleEntry<String, Integer>(name, id);
                retval.add(entry);
            }
        }
        return retval;
    }

    public Set<Map.Entry<String, Integer>> getCloudspaces(Integer deploymentId) throws HTTPException {
        HashSet<Map.Entry<String, Integer>> retval = new HashSet<Map.Entry<String, Integer>>();
        String url = this.baseUrl + "/rest/api/deployments/" + deploymentId + "/validrealms/";
        String result = this.get(url);
        if (result != null && !result.isEmpty()) {
            JSONArray cloudspaces = new JSONArray(result);
            for (int i = 0; i < cloudspaces.length(); ++i) {
                JSONObject rec = cloudspaces.getJSONObject(i);
                Integer id = rec.getInt("id");
                String name = rec.getString("name");
                AbstractMap.SimpleEntry<String, Integer> entry = new AbstractMap.SimpleEntry<String, Integer>(name, id);
                retval.add(entry);
            }
        }
        return retval;
    }

    public Set<String> getRoles(Integer deploymentId) throws HTTPException {
        HashSet<String> retval = new HashSet<String>();
        String url = this.baseUrl + "/rest/api/deployments/" + deploymentId;
        String result = this.get(url);
        LOGGER.log(Level.INFO, result);
        if (result != null && !result.isEmpty()) {
            JSONObject deployment = new JSONObject(result);
            JSONArray deploymentHosts = deployment.getJSONArray("deploymentHosts");
            for (int i = 0; i < deploymentHosts.length(); ++i) {
                JSONObject deploymentHost = deploymentHosts.getJSONObject(i);
                String role = deploymentHost.getString("systemRole");
                LOGGER.log(Level.INFO, "Adding role: " + role);
                retval.add(role);
            }
        }
        return retval;
    }

    public Set<Network> getNetworks(Integer deploymentId, Integer cloudspaceId) throws HTTPException {
        HashSet<Network> retval = new HashSet<Network>();
        String url = this.baseUrl + "/rest/api/deployments/" + deploymentId + "/networks/" + cloudspaceId;
        String result = this.get(url);
        LOGGER.log(Level.INFO, result);
        if (result != null && !result.isEmpty()) {
            JSONArray networks = new JSONArray(result);
            for (int i = 0; i < networks.length(); ++i) {
                JSONObject network = networks.getJSONObject(i);
                String id = network.getString("identifier");
                String name = network.getString("name");
                String cidr = network.getString("cidr");
                String networkFunction = network.getString("networkFunction");
                if ("CONS3RT".equals(networkFunction)) continue;
                Network net = new Network(name, id, cidr);
                retval.add(net);
            }
        }
        return retval;
    }

    public String launchDeployment(RunConfiguration launchRequest) throws HTTPException {
        String url = this.baseUrl + "/rest/api/deployments/" + launchRequest.getDeploymentId() + "/execute";
        String json = HttpWrapper.createJsonFromLaunchRequest(launchRequest);
        LOGGER.log(Level.INFO, json);
        return this.putJson(url, json);
    }

    public static String createJsonFromLaunchRequest(RunConfiguration launchRequest) {
        DeploymentRunOptions options = new DeploymentRunOptions(launchRequest);
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        builder.registerTypeAdapter(Secret.class, (Object)new SecretSerializer());
        Gson gson = builder.create();
        return gson.toJson((Object)options);
    }

    public static class HTTPException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public HTTPException(String message) {
            super(message);
        }

        public HTTPException(String message, Exception e) {
            super(message, e);
        }
    }

    public static class HttpWrapperBuilder {
        private String baseUrl;
        private String token;
        private String authenticationType;
        private String username;
        private StandardCertificateCredentials certificate;

        public HttpWrapperBuilder(String baseUrl, String token, String authenticationType) {
            this.baseUrl = baseUrl;
            this.token = token;
            this.authenticationType = authenticationType;
        }

        public HttpWrapperBuilder username(String username) {
            this.username = username;
            return this;
        }

        public HttpWrapperBuilder certificate(StandardCertificateCredentials certificate) {
            this.certificate = certificate;
            return this;
        }

        public HttpWrapper build() throws HTTPException {
            return new HttpWrapper(this.baseUrl, this.token, this.authenticationType, this.username, this.certificate);
        }
    }
}

