/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.utils;

import hudson.FilePath;
import io.jenkins.plugins.AssetBuilder;
import io.jenkins.plugins.datatype.ArchitectureType;
import io.jenkins.plugins.datatype.BitsType;
import io.jenkins.plugins.datatype.PlatformType;
import io.jenkins.plugins.utils.Cons3rtCompressUtils;
import io.jenkins.plugins.utils.ContextLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.DirectoryScanner;

public class AssetFileUtils {
    public static final Logger LOGGER = Logger.getLogger(AssetFileUtils.class.getName());
    public static final String cons3rtAssetBuilderPrefix = "CONS3RT-Asset-Builder";
    public static final String cons3rtAssetPrefix = "CONS3RT-Asset";
    public static final String wildCard = "*";
    static FilenameFilter assetPropertiesFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.equalsIgnoreCase("asset.properties");
        }
    };
    static FilenameFilter prebuiltAssetFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(AssetFileUtils.cons3rtAssetPrefix);
        }
    };

    public static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getAssetZipFromPath(FilePath buildWorkspace, FilePath providedPath) throws IOException, InterruptedException {
        File providedFile = new File(providedPath.toURI());
        if (providedFile.exists()) {
            if (providedFile.isDirectory()) {
                LOGGER.log(Level.INFO, "Provided file " + providedPath + " is a directory. Checking for top level asset.properties file", "INFO");
                String[] fileList = providedFile.list(assetPropertiesFilter);
                if (fileList == null) {
                    String message = "Could not find asset.properties file at top level of directory " + providedPath;
                    LOGGER.log(Level.WARNING, message);
                    throw new IOException(message);
                }
                List<String> assetPropsFiles = Arrays.asList(fileList);
                if (assetPropsFiles.size() > 1) {
                    String message = "Found " + assetPropsFiles.size() + " asset.properties files at top level of directory " + providedPath;
                    LOGGER.warning(message);
                    throw new IOException(message);
                }
                LOGGER.info("Found asset.properties file at top level of directory " + providedPath + ". Attempting to create zip for asset import");
                StringBuilder assetZipName = new StringBuilder();
                assetZipName.append(cons3rtAssetPrefix);
                assetZipName.append("-");
                if (providedPath.getBaseName().startsWith(cons3rtAssetBuilderPrefix)) {
                    LOGGER.info("Asset to be zipped is an asset built by the cons3rt asset builder plugin. Removing prefix and timestamp to get name");
                    String baseName = providedPath.getBaseName().replace("CONS3RT-Asset-Builder-", "");
                    String name = baseName.substring(0, baseName.lastIndexOf("-"));
                    assetZipName.append(name);
                } else {
                    assetZipName.append(providedPath.getBaseName());
                }
                String timeStamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
                assetZipName.append("-");
                assetZipName.append(timeStamp);
                assetZipName.append(".zip");
                FilePath zipFilePath = new FilePath(buildWorkspace, assetZipName.toString());
                LOGGER.info("Zipping directory " + providedPath.toURI().toString() + " to file " + zipFilePath.toURI().toString());
                Cons3rtCompressUtils.INSTANCE.zipIntoZipFileFromDir(Paths.get(zipFilePath.toURI()), Paths.get(providedPath.toURI()), false, null);
                LOGGER.info("Zip created.");
                return new File(zipFilePath.toURI());
            }
            LOGGER.log(Level.INFO, "Provided file " + providedPath + " is not a directory. Checking if file is a zip file");
            if (providedFile.getName().endsWith(".zip")) {
                LOGGER.info("Provided file " + providedPath + " is a zip file ending in .zip, this file will be used for asset upload.");
                return providedFile;
            }
            String message = "Provided file " + providedPath + " is not a zip file ending in .zip";
            LOGGER.warning(message);
            throw new IOException(message);
        }
        String message = "Provided file " + providedPath + " does not exist.";
        LOGGER.warning(message);
        throw new IOException(message);
    }

    public static FilePath createWorkingDirectory(FilePath workspace, String name) throws IOException, InterruptedException {
        try {
            String cleanedName = name.replaceAll(" ", "_");
            StringBuilder workDirName = new StringBuilder();
            workDirName.append(cons3rtAssetBuilderPrefix);
            workDirName.append("-");
            workDirName.append(cleanedName);
            workDirName.append("-");
            String timeStamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
            workDirName.append(timeStamp);
            FilePath workDir = new FilePath(workspace, workDirName.toString());
            workDir.mkdirs();
            return workDir;
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
    }

    public static void createAssetPropertiesFile(FilePath workDir, AssetBuilder assetBuilder) throws IOException, InterruptedException {
        String newline = System.getProperty("line.separator");
        String timeStamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
        StringBuilder sb = new StringBuilder();
        sb.append('#');
        sb.append("#Created by CONS3RT Jenkins Builder Plugin");
        sb.append(newline);
        sb.append('#');
        sb.append(timeStamp);
        sb.append(newline);
        sb.append("assetType=SOFTWARE");
        sb.append(newline);
        sb.append("softwareAssetType=APPLICATION");
        sb.append(newline);
        sb.append(newline);
        sb.append("name=");
        sb.append(assetBuilder.getName());
        sb.append(newline);
        sb.append("installScript=");
        sb.append(assetBuilder.getInstallScriptFileName());
        sb.append(newline);
        if (assetBuilder.getDescription() != null && !assetBuilder.getDescription().isEmpty()) {
            sb.append("description=");
            sb.append(assetBuilder.getDescription());
            sb.append(newline);
        }
        if (assetBuilder.getPlatform() != null && !assetBuilder.getPlatform().isEmpty()) {
            sb.append("applicationOsPlatform=");
            sb.append(PlatformType.valueFromDisplayName(assetBuilder.getPlatform()).name());
            sb.append(newline);
        }
        if (assetBuilder.getArchitecture() != null && !assetBuilder.getArchitecture().isEmpty()) {
            sb.append("applicationArchitecture=");
            sb.append(ArchitectureType.valueFromDisplayName(assetBuilder.getArchitecture()).name());
            sb.append(newline);
        }
        if (assetBuilder.getBits() != null && !assetBuilder.getBits().isEmpty()) {
            sb.append("applicationBits=");
            sb.append(BitsType.valueFromDisplayName(assetBuilder.getBits()).name());
            sb.append(newline);
        }
        if (assetBuilder.getCpu() != null) {
            sb.append("applicationRequiredCpuCount=");
            sb.append(assetBuilder.getCpu());
            sb.append(newline);
        }
        if (assetBuilder.getMemory() != null) {
            sb.append("requiredRam=");
            sb.append(assetBuilder.getMemory());
            sb.append(newline);
        }
        if (assetBuilder.getStorage() != null) {
            sb.append("requiredDisk=");
            sb.append(assetBuilder.getStorage());
            sb.append(newline);
        }
        if (assetBuilder.hasDocumentation()) {
            sb.append("documentationFile=");
            sb.append(assetBuilder.getDocumentationFileName());
            sb.append(newline);
        }
        if (assetBuilder.hasLicense()) {
            sb.append("licenseFile=");
            sb.append(assetBuilder.getLicenseFileName());
            sb.append(newline);
        }
        FilePath propertiesFile = new FilePath(workDir, "asset.properties");
        propertiesFile.write(sb.toString(), null);
    }

    public static FilePath verifyFileExists(FilePath workspace, String pathToFile) throws IOException, InterruptedException {
        FilePath providedPath = new FilePath(workspace, pathToFile);
        if (providedPath.exists()) {
            return providedPath;
        }
        throw new IOException("Could not find file " + providedPath.getName() + " in build workspace " + workspace.getBaseName());
    }

    public static void copyAssetFile(ContextLogger log, FilePath workspace, String relativePath, FilePath targetDirectory) throws IOException, InterruptedException {
        FilePath currentfile = AssetFileUtils.verifyFileExists(workspace, relativePath);
        FilePath targetPath = new FilePath(targetDirectory, currentfile.getName());
        log.log("Copying file: " + currentfile.getName() + " to " + targetPath.toURI());
        if (currentfile.isDirectory()) {
            log.log("Directory detected, copying contents");
            currentfile.copyRecursiveTo(targetPath);
        } else {
            currentfile.copyTo(targetPath);
        }
        log.log("Media file copied.");
    }

    public static Set<String> findWildcardMatches(FilePath workspace, String relativePath) throws IOException, InterruptedException {
        HashSet<String> results = new HashSet<String>();
        String baseDir = Paths.get(workspace.toURI()).toString();
        LOGGER.info("Searching with basedir: " + baseDir);
        LOGGER.info("Finding all files returned by search for: " + relativePath);
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setIncludes(new String[]{relativePath});
        scanner.setBasedir(baseDir);
        scanner.setCaseSensitive(true);
        scanner.scan();
        String[] dirs = scanner.getIncludedDirectories();
        String[] files = scanner.getIncludedFiles();
        for (String dir : dirs) {
            LOGGER.info("Search found directory: " + dir);
            results.add(dir);
        }
        for (String file : files) {
            LOGGER.info("Search found file: " + file);
            results.add(file);
        }
        return results;
    }

    public static FilePath findPrebuiltAsset(FilePath workspace, String prebuiltAssetName) throws IOException, InterruptedException, ParseException {
        String cleanedName = prebuiltAssetName.replaceAll(" ", "_");
        File workspaceDir = new File(workspace.toURI());
        String[] fileList = workspaceDir.list(prebuiltAssetFilter);
        if (fileList == null) {
            String message = "Could not find " + cleanedName + " in workspace.";
            LOGGER.log(Level.WARNING, message);
            throw new IOException(message);
        }
        List<String> prebuiltAssets = Arrays.asList(fileList);
        LOGGER.log(Level.INFO, "Found " + prebuiltAssets.size() + " prebuilt assets in workspace.");
        HashMap<Date, String> datedFiles = new HashMap<Date, String>();
        for (String file : prebuiltAssets) {
            LOGGER.log(Level.INFO, "Found file: " + file);
            String baseName = file.replace("CONS3RT-Asset-", "");
            String name = baseName.substring(0, baseName.lastIndexOf("-"));
            String dateString = baseName.substring(baseName.lastIndexOf("-") + 1, baseName.length());
            LOGGER.log(Level.INFO, "Found prebuilt asset with name: " + name + " and date: " + dateString);
            if (!cleanedName.equals(name)) continue;
            LOGGER.log(Level.INFO, "Pre-Built asset has desired name, adding: " + file);
            Date date = AssetFileUtils.getDateFormat().parse(dateString);
            datedFiles.put(date, file);
        }
        if (datedFiles.isEmpty()) {
            throw new IOException("A prebuilt asset for name: " + prebuiltAssetName + " was not found in workspace.");
        }
        Date newest = (Date)Collections.max(datedFiles.keySet());
        String timestamp = AssetFileUtils.getDateFormat().format(newest);
        LOGGER.log(Level.INFO, "Newest prebuilt asset: " + cleanedName + " dated: " + timestamp);
        String newestFile = (String)datedFiles.get(newest);
        return new FilePath(workspace, newestFile);
    }
}

