/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.utils;

import com.sun.jna.Platform;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheCompressUtils {
    public static final Charset CONS3RT_CHARSET = StandardCharsets.UTF_8;
    private static final CharSequence COLON = ":";
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Complained method is null checked for all parameters")
    private static String getEntryName(Path baseDirPath, Path fullFilePath, boolean includeBaseDir) {
        String entryName = includeBaseDir ? baseDirPath.getParent().relativize(fullFilePath).toString() : baseDirPath.relativize(fullFilePath).toString();
        return entryName;
    }

    /*
     * Exception decompiling
     */
    public static String getZipFileEntryAsString(Path zipFilePath, String entryToGet) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> getZipFileListing(Path zipFilePath) throws IOException {
        ArrayList<String> listing = new ArrayList<String>();
        try (ZipFile commonsZipFile = new ZipFile(zipFilePath.toFile());){
            Enumeration e = commonsZipFile.getEntries();
            while (e.hasMoreElements()) {
                listing.add(((ZipArchiveEntry)e.nextElement()).getName());
            }
        }
        return listing;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Complained method is null checked for all parameters")
    public static void unzipIntoDirFromZipFile(Path outputDirPath, Path zipFilePath, List<String> filesToInclude) throws IOException, InvalidPathException {
        LOGGER.info("unzipIntoDirFromZipFile: starting unzip of {} into directory {} (filesToInclude = {})", new Object[]{zipFilePath, outputDirPath, filesToInclude});
        if (!outputDirPath.toFile().exists()) {
            LOGGER.info("unzipIntoDirFromZipFile: unzip destination directory {} does not exist - will try to create", (Object)outputDirPath);
            Files.createDirectories(outputDirPath, new FileAttribute[0]);
        }
        if (!outputDirPath.toFile().canWrite()) {
            String msg = "unzip destination directory " + outputDirPath + " is not writable";
            LOGGER.warn("unzipIntoDirFromZipFile: {}", (Object)msg);
            throw new InvalidPathException(msg, outputDirPath.toString());
        }
        boolean includeListProvided = filesToInclude != null && !filesToInclude.isEmpty();
        ArrayList<Object> localIncludeList = includeListProvided ? new ArrayList<String>(filesToInclude) : new ArrayList();
        try (ZipFile commonsZipFile = new ZipFile(zipFilePath.toFile());){
            Enumeration e = commonsZipFile.getEntries();
            while (e.hasMoreElements()) {
                Throwable throwable;
                Throwable throwable2;
                InputStream in;
                boolean skip;
                if (includeListProvided) {
                    if (localIncludeList.isEmpty()) {
                        if (!LOGGER.isDebugEnabled()) break;
                        LOGGER.debug("unzipIntoDirFromZipFile: include file list empty - exiting loop");
                        break;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("unzipIntoDirFromZipFile: files left to extract {}", localIncludeList);
                    }
                }
                ZipArchiveEntry entry = (ZipArchiveEntry)e.nextElement();
                String entryName = entry.getName();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("unzipIntoDirFromZipFile: found entry {} (directory = {})", (Object)entryName, (Object)entry.isDirectory());
                }
                boolean bl = skip = Platform.isWindows() && entryName.contains(COLON);
                if (skip) {
                    LOGGER.info("unzipIntoDirFromZipFile: skipping entry {} containing {} on Windows platform", (Object)entryName, (Object)COLON);
                    continue;
                }
                Path entryOutputPath = outputDirPath.resolve(entryName);
                if (entry.isDirectory()) {
                    if (!includeListProvided || localIncludeList.contains(entryName)) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("unzipIntoDirFromZipFile: creating directory {})", (Object)entryOutputPath);
                        }
                        Files.createDirectories(entryOutputPath, new FileAttribute[0]);
                        continue;
                    }
                    LOGGER.info("unzipIntoDirFromZipFile: skipping directory entry {} as it is not on provided list of files to include", (Object)entryName);
                    continue;
                }
                if (entry.isUnixSymlink()) {
                    if (!includeListProvided || localIncludeList.contains(entryName)) {
                        String targetString;
                        in = commonsZipFile.getInputStream(entry);
                        throwable2 = null;
                        try {
                            throwable = null;
                            try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
                                int length;
                                byte[] buffer = new byte[1024];
                                while ((length = in.read(buffer)) != -1) {
                                    result.write(buffer, 0, length);
                                }
                                targetString = result.toString(CONS3RT_CHARSET.name());
                            }
                            catch (Throwable buffer) {
                                throwable = buffer;
                                throw buffer;
                            }
                        }
                        catch (Throwable result) {
                            throwable2 = result;
                            throw result;
                        }
                        finally {
                            if (in != null) {
                                if (throwable2 != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable result) {
                                        throwable2.addSuppressed(result);
                                    }
                                } else {
                                    in.close();
                                }
                            }
                        }
                        Path targetPath = FileSystems.getDefault().getPath(targetString, new String[0]);
                        Files.createSymbolicLink(entryOutputPath, targetPath, new FileAttribute[0]);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("unzipIntoDirFromZipFile: created sym link at {} pointing to {})", (Object)entryOutputPath, (Object)targetPath);
                        }
                        if (!includeListProvided) continue;
                        localIncludeList.remove(entryName);
                        continue;
                    }
                    LOGGER.info("unzipIntoDirFromZipFile: skipping sym link entry {} as it is not on provided list of files to include", (Object)entryName);
                    continue;
                }
                if (!includeListProvided || localIncludeList.contains(entryName)) {
                    Path entryOutputPathParent = entryOutputPath.getParent();
                    if (!entryOutputPathParent.toFile().exists()) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("unzipIntoDirFromZipFile: creating output path parent {})", (Object)entryOutputPathParent);
                        }
                        Files.createDirectories(entryOutputPathParent, new FileAttribute[0]);
                    }
                    in = commonsZipFile.getInputStream(entry);
                    throwable2 = null;
                    try {
                        throwable = null;
                        try (BufferedInputStream bin = new BufferedInputStream(in);
                             FileOutputStream out = new FileOutputStream(entryOutputPath.toFile());){
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("unzipIntoDirFromZipFile: copying entry {} to {})", (Object)entryName, (Object)entryOutputPath);
                            }
                            IOUtils.copy((InputStream)bin, (OutputStream)out);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (in != null) {
                            if (throwable2 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                    if (!includeListProvided) continue;
                    localIncludeList.remove(entryName);
                    continue;
                }
                LOGGER.info("unzipIntoDirFromZipFile: skipping file entry {} as it is not on provided list of files to include", (Object)entryName);
            }
            if (includeListProvided && !localIncludeList.isEmpty()) {
                LOGGER.warn("unzipIntoDirFromZipFile: non-empty include list was provided, but one or more entries not found so zip was entirely traversed (remaining entries = {})", localIncludeList);
            }
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Complained method is null checked for all parameters")
    public static void zipIntoZipFileFromDir(Path destZipFilePath, final Path sourceDirPath, final boolean includeSourceDir, final String extensionToMatch) throws IOException, InvalidPathException {
        Path parentDir = destZipFilePath.getParent();
        if (parentDir == null || !Files.isWritable(parentDir)) {
            String msg = "zip destination directory " + parentDir + " failed writability test";
            LOGGER.warn("zipIntoZipFileFromDir: {}", (Object)msg);
            throw new InvalidPathException(msg, parentDir == null ? "null" : parentDir.toString());
        }
        try (FileOutputStream fos = new FileOutputStream(destZipFilePath.toFile());
             BufferedOutputStream bfos = new BufferedOutputStream(fos);
             final ZipArchiveOutputStream zaos = (ZipArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)bfos);){
            zaos.setUseZip64(Zip64Mode.AsNeeded);
            Files.walkFileTree(sourceDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes attrs) throws IOException {
                    String entryName;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("preVisitDirectory: entered for {} (isDirectory = {} isRegularFile = {})", new Object[]{dirPath, attrs.isDirectory(), attrs.isRegularFile()});
                    }
                    if (!(entryName = ApacheCompressUtils.getEntryName(sourceDirPath, dirPath, includeSourceDir)).isEmpty()) {
                        String dirEntryName = entryName.concat("/");
                        ZipArchiveEntry entry = new ZipArchiveEntry(dirEntryName);
                        try {
                            zaos.putArchiveEntry((ArchiveEntry)entry);
                        }
                        finally {
                            zaos.closeArchiveEntry();
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("preVisitDirectory: added zip dir entry {} (source path {})", (Object)dirEntryName, (Object)dirPath);
                        }
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("preVisitDirectory: skipping add of zip dir entry for {} (entry name is empty)", (Object)dirPath);
                    }
                    return FileVisitResult.CONTINUE;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Complained method is null checked for all parameters")
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("visitFile: entered for {} (isDirectory = {} isRegularFile = {} isSymbolicLink = {})", new Object[]{filePath, attrs.isDirectory(), attrs.isRegularFile(), attrs.isSymbolicLink()});
                    }
                    if (extensionToMatch != null && !extensionToMatch.isEmpty() && !filePath.getFileName().toString().endsWith(".".concat(extensionToMatch))) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("visitFile: not adding {} - did not match extension {}", (Object)filePath, (Object)extensionToMatch);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    String entryName = ApacheCompressUtils.getEntryName(sourceDirPath, filePath, includeSourceDir);
                    ZipArchiveEntry entry = new ZipArchiveEntry(entryName);
                    if (attrs.isSymbolicLink()) {
                        Path realPath = null;
                        try {
                            realPath = filePath.toRealPath(new LinkOption[0]);
                        }
                        catch (IOException ioe) {
                            LOGGER.warn("visitFile: could not find target for symbolic link entry {} - skipping", (Object)entryName);
                        }
                        if (realPath != null) {
                            String realPathEntryName = ApacheCompressUtils.getEntryName(sourceDirPath, realPath, includeSourceDir);
                            entry.setUnixMode(41471);
                            zaos.putArchiveEntry((ArchiveEntry)entry);
                            try {
                                zaos.write(realPathEntryName.getBytes(CONS3RT_CHARSET));
                            }
                            finally {
                                zaos.closeArchiveEntry();
                            }
                            LOGGER.info("visitFile: added zip file symbolic link entry {} pointing to target path {}", (Object)entryName, (Object)realPathEntryName);
                        }
                    } else {
                        entry.setSize(filePath.toFile().length());
                        zaos.putArchiveEntry((ArchiveEntry)entry);
                        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(filePath.toFile()));){
                            IOUtils.copy((InputStream)input, (OutputStream)zaos);
                        }
                        finally {
                            zaos.closeArchiveEntry();
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("visitFile: added zip file entry {} (source path {})", (Object)entryName, (Object)filePath);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (ArchiveException e) {
            String msg = " caught " + ((Object)((Object)e)).getClass().getSimpleName() + " creating archive stream into " + destZipFilePath + " (message = " + e.getMessage() + ")";
            LOGGER.info("zipIntoZipFileFromDir: {}", (Object)msg);
            throw new IOException(msg);
        }
    }

    private ApacheCompressUtils() {
    }
}

