/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.datatype;

import hudson.util.Secret;
import io.jenkins.plugins.datatype.HostOption;
import io.jenkins.plugins.datatype.Property;
import io.jenkins.plugins.datatype.RunConfiguration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeploymentRunOptions {
    private String deploymentRunName;
    private String endState;
    private Secret password;
    private String username;
    private boolean locked;
    private boolean endExisting;
    private boolean retainOnError;
    private Integer virtualizationRealmId;
    private List<Property> properties;
    private Set<HostOption> hostOptions;

    public DeploymentRunOptions(RunConfiguration request) {
        this.deploymentRunName = request.getDeploymentRunName();
        this.virtualizationRealmId = request.getCloudspaceId();
        this.endState = request.isReleaseResources() ? "TESTS_EXECUTED_RESOURCES_RELEASED" : "TESTS_EXECUTED_RESOURCES_RESERVED";
        this.username = request.getCreatedUsername();
        this.password = request.getPassword();
        this.locked = request.isLocked();
        this.endExisting = request.isEndExisting();
        this.retainOnError = request.isRetainOnError();
        this.properties = request.getProperties();
        if (request.getHostOptions() != null) {
            this.setHostOptions(new HashSet<HostOption>(request.getHostOptions()));
        } else {
            this.setHostOptions(new HashSet<HostOption>());
        }
    }

    public String getDeploymentRunName() {
        return this.deploymentRunName;
    }

    public String getEndState() {
        return this.endState;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public Integer getVirtualizationRealmId() {
        return this.virtualizationRealmId;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isEndExisting() {
        return this.endExisting;
    }

    public boolean isRetainOnError() {
        return this.retainOnError;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Set<HostOption> getHostOptions() {
        return this.hostOptions;
    }

    public void setHostOptions(Set<HostOption> hostOptions) {
        this.hostOptions = hostOptions;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setEndExisting(boolean endExisting) {
        this.endExisting = endExisting;
    }

    public void setRetainOnError(boolean retainOnError) {
        this.retainOnError = retainOnError;
    }

    public void setDeploymentRunName(String deploymentRunName) {
        this.deploymentRunName = deploymentRunName;
    }

    public void setEndState(String endState) {
        this.endState = endState;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setVirtualizationRealmId(Integer virtualizationRealmId) {
        this.virtualizationRealmId = virtualizationRealmId;
    }
}

