/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.datatype;

public enum ArchitectureType {
    X86("x86"),
    X64("x64"),
    ARM("ARM"),
    SPARC("SPARC"),
    PPCLE("POWER PC Little Endian");

    private String displayName;

    private ArchitectureType(String displayName) {
        this.displayName = displayName;
    }

    public static ArchitectureType valueFromDisplayName(String displayName) {
        boolean found = false;
        ArchitectureType retval = null;
        for (ArchitectureType platform : ArchitectureType.values()) {
            if (!displayName.equals(platform.getDisplayName())) continue;
            retval = platform;
            found = true;
            break;
        }
        if (found) {
            return retval;
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

