/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.BuildStepAssets;
import io.jenkins.plugins.Cons3rtSite;
import io.jenkins.plugins.datatype.Network;
import io.jenkins.plugins.datatype.RunConfiguration;
import io.jenkins.plugins.exceptions.InvalidNameException;
import io.jenkins.plugins.utils.AssetFileUtils;
import io.jenkins.plugins.utils.ContextLogger;
import io.jenkins.plugins.utils.HttpWrapper;
import io.jenkins.plugins.utils.NameUtils;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class Cons3rtPublisher
extends Recorder {
    public static final Logger LOGGER = Logger.getLogger(Cons3rtPublisher.class.getName());
    private static final String createAssetAction = "createAsset";
    private static final String updateAssetAction = "updateAsset";
    private static final String prebuiltAssetType = "prebuilt";
    private static final String filepathAssetType = "filepath";
    private Cons3rtSite site;
    private Integer assetId;
    private String assetStyle;
    private String prebuiltAssetName;
    private String filepath;
    private String actionType;
    private boolean attemptUploadOnBuildFailure;
    private boolean deleteCreatedAssetAfterUpload;
    private RunConfiguration launchRequest;
    private static final Map<Integer, Set<Map.Entry<String, Integer>>> availableCloudspaces = new HashMap<Integer, Set<Map.Entry<String, Integer>>>();
    private static final Set<String> availableRoles = new HashSet<String>();
    private static final Set<Network> availableNetworks = new HashSet<Network>();
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public Cons3rtPublisher(Cons3rtSite site, Integer assetId, String assetStyle, String filepath, String prebuiltAssetName, String actionType, boolean attemptUploadOnBuildFailure, boolean deleteCreatedAssetAfterUpload, RunConfiguration launchRequest) {
        this.setSite(site);
        LOGGER.log(Level.INFO, "Entering constructor with values: " + assetStyle + " " + actionType);
        this.setAssetStyle(assetStyle);
        if (this.assetStyle == null || this.assetStyle.isEmpty()) {
            this.setAssetStyle(prebuiltAssetType);
        }
        switch (this.getAssetStyle()) {
            case "prebuilt": {
                this.prebuiltAssetName = prebuiltAssetName;
                this.filepath = null;
                break;
            }
            case "filepath": {
                this.filepath = filepath;
                this.prebuiltAssetName = null;
                break;
            }
            default: {
                this.filepath = filepath;
                this.prebuiltAssetName = null;
            }
        }
        this.actionType = actionType;
        if (this.actionType == null || this.actionType.isEmpty()) {
            this.setActionType(createAssetAction);
        }
        switch (this.getActionType()) {
            case "createAsset": {
                this.setAssetId(null);
                break;
            }
            case "updateAsset": {
                this.assetId = assetId;
                break;
            }
            default: {
                this.setAssetId(null);
            }
        }
        this.attemptUploadOnBuildFailure = attemptUploadOnBuildFailure;
        this.deleteCreatedAssetAfterUpload = deleteCreatedAssetAfterUpload;
        this.launchRequest = launchRequest;
        if (this.launchRequest != null) {
            this.launchRequest.setCloudspaceId(Cons3rtPublisher.getCloudspaceIdForName(this.launchRequest.getCloudspaceName()));
        }
        LOGGER.log(Level.INFO, "Received Site: " + this.site.getUrl() + " with action type: " + this.actionType + " and asset id: " + this.assetId);
    }

    public static Integer getCloudspaceIdForName(String cloudspaceName) {
        Integer retval = null;
        if (cloudspaceName != null) {
            block0: for (Map.Entry<Integer, Set<Map.Entry<String, Integer>>> entry : availableCloudspaces.entrySet()) {
                Set<Map.Entry<String, Integer>> cloudspaces = entry.getValue();
                for (Map.Entry<String, Integer> cloudspace : cloudspaces) {
                    if (!cloudspace.getKey().equals(cloudspaceName)) continue;
                    retval = cloudspace.getValue();
                    continue block0;
                }
            }
        }
        return retval;
    }

    public String getActionType() {
        return this.actionType;
    }

    public boolean isDeleteCreatedAssetAfterUpload() {
        return this.deleteCreatedAssetAfterUpload;
    }

    public void setDeleteCreatedAssetAfterUpload(boolean deleteCreatedAssetAfterUpload) {
        this.deleteCreatedAssetAfterUpload = deleteCreatedAssetAfterUpload;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public Integer getAssetId() {
        return this.assetId;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public static Map<Integer, Set<Map.Entry<String, Integer>>> getAvailableCloudspaces() {
        return new HashMap<Integer, Set<Map.Entry<String, Integer>>>(availableCloudspaces);
    }

    public static Set<String> getAvailableRoles() {
        return new HashSet<String>(availableRoles);
    }

    public static Set<Network> getAvailableNetworks() {
        return new HashSet<Network>(availableNetworks);
    }

    public RunConfiguration getLaunchRequest() {
        return this.launchRequest;
    }

    public String getPrebuiltAssetName() {
        return this.prebuiltAssetName;
    }

    public String getAssetStyle() {
        return this.assetStyle;
    }

    public Cons3rtSite getSite() {
        return this.site;
    }

    public void setSite(Cons3rtSite site) {
        this.site = site;
    }

    public void setAssetStyle(String assetStyle) {
        this.assetStyle = assetStyle;
    }

    public void setPrebuiltAssetName(String prebuiltAssetName) {
        this.prebuiltAssetName = prebuiltAssetName;
    }

    public void setLaunchRequested(RunConfiguration launchRequest) {
        this.launchRequest = launchRequest;
    }

    public static void addAvailableCloudspaces(Integer key, Set<Map.Entry<String, Integer>> cloudspaces) {
        availableCloudspaces.put(key, cloudspaces);
    }

    public static void setAvailableNetworks(Set<Network> availableNetworks) {
        Cons3rtPublisher.availableNetworks.clear();
        Cons3rtPublisher.availableNetworks.addAll(availableNetworks);
    }

    public static void setAvailableRoles(Set<String> availableRoles) {
        Cons3rtPublisher.availableRoles.clear();
        Cons3rtPublisher.availableRoles.addAll(availableRoles);
    }

    public boolean isAttemptUploadOnBuildFailure() {
        return this.attemptUploadOnBuildFailure;
    }

    public void setAttemptUploadOnBuildFailure(boolean attemptUploadOnBuildFailure) {
        this.attemptUploadOnBuildFailure = attemptUploadOnBuildFailure;
    }

    public void setAssetId(Integer assetId) {
        this.assetId = assetId;
    }

    public void setFilepath(String filepath) {
        this.filepath = filepath;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Complained method is null checked for all parameters")
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ContextLogger log = new ContextLogger(listener.getLogger(), "CONS3RT Plugin", Level.INFO);
        LOGGER.log(Level.INFO, "attemptUploadOnBuildFailure: " + this.attemptUploadOnBuildFailure);
        if (build != null) {
            if (Result.ABORTED.equals(build.getResult())) {
                log.log("Skipping asset upload or update as build was aborted.", Level.SEVERE);
                return true;
            }
            if (this.site == null) {
                log.log("No CONS3RT site found. This is likely a configuration problem.", Level.SEVERE);
                build.setResult(Result.UNSTABLE);
                return true;
            }
            if (!this.attemptUploadOnBuildFailure && Result.FAILURE.equals(build.getResult())) {
                log.log("Skipping asset upload or update as build failed and user did not request to attempt upload on build failure.", Level.SEVERE);
                return false;
            }
            if (this.attemptUploadOnBuildFailure && Result.FAILURE.equals(build.getResult())) {
                log.log("Attempting to upload or update despite build failure, as requested.");
            }
            String baseUrl = this.site.getUrl();
            String token = this.site.getToken();
            String authenticationType = this.site.getAuthenticationType();
            try {
                String result;
                FilePath providedPath;
                log.log("Site Url: " + baseUrl + " authentication type: " + authenticationType + " action type: " + this.getActionType());
                HttpWrapper.HttpWrapperBuilder builder = new HttpWrapper.HttpWrapperBuilder(baseUrl, token, authenticationType);
                if (Cons3rtPublisher.isCeritificateAuthentication(authenticationType)) {
                    builder.certificate(this.site.getCertificate());
                } else if (Cons3rtPublisher.isUsernameAuthentication(authenticationType)) {
                    builder.username(this.site.getUsername());
                }
                HttpWrapper wrapper = builder.build();
                if (build.getWorkspace() != null) {
                    switch (this.getAssetStyle()) {
                        case "prebuilt": {
                            if (this.prebuiltAssetName != null) {
                                providedPath = AssetFileUtils.findPrebuiltAsset(build.getWorkspace(), this.prebuiltAssetName);
                                break;
                            }
                            String message = "Asset type requested: " + this.getAssetStyle() + " but no pre-built asset name provided.";
                            log.log(message, Level.SEVERE);
                            throw new IOException(message);
                        }
                        case "filepath": {
                            providedPath = new FilePath(build.getWorkspace(), this.getFilepath());
                            break;
                        }
                        default: {
                            String message = "Invalid asset type requested: " + this.getAssetStyle();
                            log.log(message, Level.SEVERE);
                            throw new IOException(message);
                        }
                    }
                } else {
                    String message = "This build has no workspace an asset will not be able to be found for asset type: " + this.getAssetStyle();
                    log.log(message, Level.SEVERE);
                    throw new IOException(message);
                }
                File assetZipForUpload = AssetFileUtils.getAssetZipFromPath(build.getWorkspace(), providedPath);
                log.log("Using asset zip file: " + assetZipForUpload.getAbsolutePath());
                log.log("Received action type: " + this.getActionType());
                switch (this.getActionType()) {
                    case "createAsset": {
                        result = wrapper.createAsset(assetZipForUpload);
                        break;
                    }
                    case "updateAsset": {
                        result = wrapper.updateAsset(this.assetId, assetZipForUpload);
                        break;
                    }
                    default: {
                        String message = "Invalid action type requested: " + this.getActionType();
                        log.log(message, Level.SEVERE);
                        throw new IOException(message);
                    }
                }
                log.log(result);
                if (this.isRunRequested()) {
                    log.log("Launch of deployment " + this.launchRequest.getDeploymentId() + " into cloudspace " + this.launchRequest.getCloudspaceName() + " id " + this.getLaunchRequest().getCloudspaceId() + " was requested.");
                    String deploymentRunId = wrapper.launchDeployment(this.launchRequest);
                    log.log("Launch was successful. Deployment run id: " + deploymentRunId);
                } else {
                    log.log("No deployment launch was requested.");
                }
                if (prebuiltAssetType.equals(this.assetStyle) && this.deleteCreatedAssetAfterUpload) {
                    log.log("Deletion of created asset was requested. Attempting to delete: " + assetZipForUpload.getName());
                    boolean deleted = assetZipForUpload.delete();
                    if (!deleted) {
                        log.log("Failed to delete: " + assetZipForUpload.getName());
                    }
                }
            }
            catch (HttpWrapper.HTTPException | SecurityException | ParseException e) {
                log.log("Caught: " + e.getClass().getName() + " message: " + e.getMessage(), Level.SEVERE);
                build.setResult(Result.FAILURE);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isActionType(String given) {
        return this.actionType.equals(given);
    }

    public boolean isAssetStyle(String given) {
        return this.assetStyle.equals(given);
    }

    public String runRequested() {
        String retval = this.getLaunchRequest() != null ? "true" : "false";
        LOGGER.log(Level.INFO, "runRequested equals: " + retval);
        return retval;
    }

    public boolean isRunRequested() {
        return Boolean.valueOf(this.runRequested());
    }

    public static boolean isCeritificateAuthentication(String authenticationType) {
        return authenticationType.equals("certificate");
    }

    public static boolean isUsernameAuthentication(String authenticationType) {
        return authenticationType.equals("username");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(Cons3rtPublisher.class);
            this.load();
        }

        protected DescriptorImpl(Class<? extends Publisher> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return "Create or Update a CONS3RT Asset";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String output = formData.toString();
            LOGGER.info(output);
            if (req != null) {
                Cons3rtPublisher instance = (Cons3rtPublisher)((Object)req.bindJSON(this.clazz, formData));
                LOGGER.log(Level.INFO, "Entering new instance with values: " + instance.assetStyle + " " + instance.actionType);
                LOGGER.log(Level.INFO, "Entering new instance with values: " + instance.getSite().getUrl());
                return instance;
            }
            return null;
        }

        public FormValidation doCheckUrl(@QueryParameter(value="url") String url) {
            if (url == null || url.trim().isEmpty()) {
                return FormValidation.error((String)"Url not specified!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCertificateId(@QueryParameter(value="certificateId") String certificateId) {
            if (certificateId == null || certificateId.trim().isEmpty()) {
                return FormValidation.error((String)"Certificate not specified!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDeploymentId(@QueryParameter(value="deploymentId") Integer deploymentId) {
            if (deploymentId == null || deploymentId < 0) {
                return FormValidation.error((String)"An existing deployment id must be provided");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDeploymentRunUsername(@QueryParameter(value="deploymentRunUsername") String deploymentRunUsername) {
            if (deploymentRunUsername == null || deploymentRunUsername.trim().isEmpty()) {
                return FormValidation.error((String)"A username must be provided");
            }
            try {
                NameUtils.checkCreatedUsernameRestrictions(deploymentRunUsername);
            }
            catch (InvalidNameException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDeploymentRunPassword(@QueryParameter(value="deploymentRunPassword") String deploymentRunPassword) {
            if (deploymentRunPassword == null || deploymentRunPassword.trim().isEmpty()) {
                return FormValidation.error((String)"A password must be provided");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDeploymentRunName(@QueryParameter(value="deploymentRunName") String deploymentRunName) {
            try {
                NameUtils.checkDeploymentRunNameRestrictions(deploymentRunName);
            }
            catch (InvalidNameException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTokenId(@QueryParameter(value="tokenId") String tokenId) {
            if (tokenId == null || tokenId.trim().isEmpty()) {
                return FormValidation.error((String)"Token not specified!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUsername(@QueryParameter(value="username") String username) {
            if (username == null || username.trim().isEmpty()) {
                return FormValidation.error((String)"Username not specified!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProperty(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"A value must be provided");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFilepath(@QueryParameter String filepath) {
            if (filepath == null || filepath.trim().isEmpty()) {
                return FormValidation.error((String)"A filepath was not provided");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAssetId(@QueryParameter(value="assetId") Integer assetId) {
            if (assetId == null || assetId < 1) {
                return FormValidation.error((String)"An existing asset id must be provided");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillPrebuiltAssetNameItems() {
            LOGGER.info("Entering load prebuild names");
            StandardListBoxModel retval = new StandardListBoxModel();
            for (String name : BuildStepAssets.INSTANCE.getNames()) {
                LOGGER.info("Adding name: " + name);
                retval.add(name);
            }
            return retval;
        }
    }
}

