/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.pipeline;

import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Extension
public class PipelineScriptSlicer
extends UnorderedStringSlicer<WorkflowJob> {
    public PipelineScriptSlicer() {
        super(new PipelineScriptSliceSpec());
    }

    @Override
    public void loadPluginDependencyClass() {
        CpsFlowDefinition.class.getClass();
    }

    public static class PipelineScriptSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<WorkflowJob> {
        private static final String DEFINED_IN_SCM = "(Defined in SCM)";
        private static final String EMPTY = "(Empty)";

        @Override
        public String getDefaultValueString() {
            return DEFINED_IN_SCM;
        }

        @Override
        public String getName() {
            return "Pipeline Script Slicer";
        }

        @Override
        public String getName(WorkflowJob item) {
            return item.getFullName();
        }

        @Override
        public String getUrl() {
            return "pipelinescriptslicestring";
        }

        @Override
        public List<String> getValues(WorkflowJob item) {
            String flow;
            FlowDefinition definition = item.getDefinition();
            String string = flow = definition == null ? EMPTY : DEFINED_IN_SCM;
            if (definition instanceof CpsFlowDefinition && StringUtils.isEmpty((String)(flow = ((CpsFlowDefinition)definition).getScript()))) {
                flow = EMPTY;
            }
            return Collections.singletonList(flow);
        }

        @Override
        public List<WorkflowJob> getWorkDomain() {
            return TopLevelItemSelector.getAllTopLevelItems(WorkflowJob.class);
        }

        @Override
        public boolean setValues(WorkflowJob item, List<String> set) {
            String newValue;
            if (set.isEmpty() || set.size() > 1) {
                return false;
            }
            String oldValue = this.getValues(item).iterator().next();
            if (!oldValue.equals(newValue = set.iterator().next())) {
                switch (newValue) {
                    case "(Defined in SCM)": {
                        break;
                    }
                    case "(Empty)": {
                        item.setDefinition((FlowDefinition)new CpsFlowDefinition("", true));
                    }
                    default: {
                        item.setDefinition((FlowDefinition)new CpsFlowDefinition(newValue, true));
                    }
                }
            }
            return false;
        }
    }
}

