/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.logrotator;

import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.Job;
import hudson.tasks.LogRotator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class LogRotationSlicer
extends UnorderedStringSlicer<Job> {
    public LogRotationSlicer(UnorderedStringSlicer.UnorderedStringSlicerSpec<Job> spec) {
        super(spec);
    }

    public static boolean equals(LogRotator r1, LogRotator r2) {
        if (r1 == r2) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.getDaysToKeep() != r2.getDaysToKeep()) {
            return false;
        }
        if (r1.getNumToKeep() != r2.getNumToKeep()) {
            return false;
        }
        if (r1.getArtifactDaysToKeep() != r2.getArtifactDaysToKeep()) {
            return false;
        }
        return r1.getArtifactNumToKeep() == r2.getArtifactNumToKeep();
    }

    public static class ArtifactBuildsSliceSpec
    extends AbstractLogRotationSliceSpec {
        public ArtifactBuildsSliceSpec() {
            super("Max # of builds to keep with artifacts", "artifactsbuilds");
        }

        @Override
        protected String getValue(LogRotator rotator) {
            return rotator.getArtifactNumToKeepStr();
        }

        @Override
        protected int getNewArtifactBuilds(int oldValue, int newValue) {
            return newValue;
        }
    }

    public static class ArtifactDaysSliceSpec
    extends AbstractLogRotationSliceSpec {
        public ArtifactDaysSliceSpec() {
            super("Days to keep artifacts", "artifactsdays");
        }

        @Override
        protected String getValue(LogRotator rotator) {
            return rotator.getArtifactDaysToKeepStr();
        }

        @Override
        protected int getNewArtifactDays(int oldDays, int newValue) {
            return newValue;
        }
    }

    public static class LogRotationBuildsSliceSpec
    extends AbstractLogRotationSliceSpec {
        public LogRotationBuildsSliceSpec() {
            super("Max # of builds to keep", "logrotationbuilds");
        }

        @Override
        protected String getValue(LogRotator rotator) {
            return rotator.getNumToKeepStr();
        }

        @Override
        protected int getNewBuilds(int oldBuilds, int newValue) {
            return newValue;
        }
    }

    public static class LogRotationDaysSliceSpec
    extends AbstractLogRotationSliceSpec {
        public LogRotationDaysSliceSpec() {
            super("Days to keep builds", "logrotationdays");
        }

        @Override
        protected String getValue(LogRotator rotator) {
            return rotator.getDaysToKeepStr();
        }

        @Override
        protected int getNewDays(int oldDays, int newValue) {
            return newValue;
        }
    }

    protected static abstract class AbstractLogRotationSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<Job> {
        private static final String DISABLED = "(Disabled)";
        private String displayName;
        private String url;

        public AbstractLogRotationSliceSpec(String displayName, String url) {
            this.displayName = "Discard Old Builds Slicer - " + displayName;
            this.url = url;
        }

        @Override
        public String getName() {
            return this.displayName;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getDefaultValueString() {
            return DISABLED;
        }

        @Override
        public String getName(Job item) {
            return item.getFullName();
        }

        @Override
        public List<String> getValues(Job item) {
            String retString = null;
            LogRotator logrotator = item.getLogRotator();
            if (logrotator == null) {
                retString = DISABLED;
            } else {
                retString = this.getValue(logrotator);
                if (retString.length() == 0) {
                    retString = DISABLED;
                }
            }
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(retString);
            return ret;
        }

        protected abstract String getValue(LogRotator var1);

        @Override
        public List<Job> getWorkDomain() {
            return TopLevelItemSelector.getAllTopLevelItems(Job.class);
        }

        @Override
        public boolean setValues(Job item, List<String> set) {
            LogRotator newlogrotator;
            if (set.isEmpty()) {
                return false;
            }
            LogRotator logrotator = item.getLogRotator();
            int days = -1;
            int builds = -1;
            int artifactDaysToKeep = -1;
            int artifactNumToKeep = -1;
            if (logrotator != null) {
                days = logrotator.getDaysToKeep();
                builds = logrotator.getNumToKeep();
                artifactDaysToKeep = logrotator.getArtifactDaysToKeep();
                artifactNumToKeep = logrotator.getArtifactNumToKeep();
            }
            int newInt = -1;
            String newString = null;
            Iterator<String> iterator = set.iterator();
            if (iterator.hasNext()) {
                String line;
                newString = line = iterator.next();
            }
            if (!DISABLED.equals(newString)) {
                newInt = Integer.parseInt(newString);
            }
            if (!LogRotationSlicer.equals(newlogrotator = new LogRotator(days = this.getNewDays(days, newInt), builds = this.getNewBuilds(builds, newInt), artifactDaysToKeep = this.getNewArtifactDays(artifactDaysToKeep, newInt), artifactNumToKeep = this.getNewArtifactBuilds(artifactNumToKeep, newInt)), logrotator)) {
                try {
                    item.setLogRotator(newlogrotator);
                    item.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
            return false;
        }

        protected int getNewDays(int oldDays, int newValue) {
            return oldDays;
        }

        protected int getNewBuilds(int oldBuilds, int newValue) {
            return oldBuilds;
        }

        protected int getNewArtifactDays(int oldValue, int newValue) {
            return oldValue;
        }

        protected int getNewArtifactBuilds(int oldValue, int newValue) {
            return oldValue;
        }
    }

    @Extension
    public static class ArtifactBuilds
    extends LogRotationSlicer {
        public ArtifactBuilds() {
            super(new ArtifactBuildsSliceSpec());
        }
    }

    @Extension
    public static class ArtifactDays
    extends LogRotationSlicer {
        public ArtifactDays() {
            super(new ArtifactDaysSliceSpec());
        }
    }

    @Extension
    public static class Count
    extends LogRotationSlicer {
        public Count() {
            super(new LogRotationBuildsSliceSpec());
        }
    }

    @Extension
    public static class Days
    extends LogRotationSlicer {
        public Days() {
            super(new LogRotationDaysSliceSpec());
        }
    }
}

