/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.logfilesizechecker;

import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Describable;
import hudson.plugins.logfilesizechecker.LogfilesizecheckerWrapper;
import hudson.util.DescribableList;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@Extension
public class LogfilesizecheckerSlicer
extends UnorderedStringSlicer<BuildableItemWithBuildWrappers> {
    public LogfilesizecheckerSlicer() {
        super(new LogfilesizeSliceSpec());
    }

    @Override
    public boolean isLoaded() {
        try {
            LogfilesizeSliceSpec.newLogfilesizecheckerWrapper(0, false, false);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static class LogfilesizeSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<BuildableItemWithBuildWrappers> {
        private static final String DISABLED = "(Disabled)";
        private static final String SEPARATOR = ",";

        @Override
        public String getName() {
            return "Log File Size";
        }

        @Override
        public String getUrl() {
            return "logfilesize";
        }

        @Override
        public List<BuildableItemWithBuildWrappers> getWorkDomain() {
            return TopLevelItemSelector.getAllTopLevelItems(BuildableItemWithBuildWrappers.class);
        }

        @Override
        public List<String> getValues(BuildableItemWithBuildWrappers item) {
            BuildableItemWithBuildWrappers bi = item;
            DescribableList wrappers = bi.getBuildWrappersList();
            ArrayList<String> values = new ArrayList<String>();
            LogfilesizecheckerWrapper wrapper = (LogfilesizecheckerWrapper)wrappers.get(LogfilesizecheckerWrapper.class);
            if (wrapper != null) {
                String value = wrapper.setOwn + SEPARATOR + wrapper.maxLogSize + SEPARATOR + wrapper.failBuild;
                values.add(value);
            }
            if (values.isEmpty()) {
                values.add(DISABLED);
            }
            return values;
        }

        @Override
        public boolean setValues(BuildableItemWithBuildWrappers item, List<String> set) {
            BuildableItemWithBuildWrappers bi = item;
            DescribableList wrappers = bi.getBuildWrappersList();
            boolean changed = false;
            LogfilesizecheckerWrapper wrapper = (LogfilesizecheckerWrapper)wrappers.get(LogfilesizecheckerWrapper.class);
            boolean delete = false;
            boolean newSetOwn = false;
            boolean newFail = false;
            int newMaxLogSize = 0;
            String line = set.iterator().next();
            if (DISABLED.equals(line) || StringUtils.isEmpty((String)line)) {
                delete = true;
            } else {
                String[] split = line.split(SEPARATOR);
                newSetOwn = Boolean.parseBoolean(split[0]);
                newMaxLogSize = Integer.parseInt(split[1]);
                newFail = Boolean.parseBoolean(split[2]);
            }
            if (wrapper != null) {
                boolean oldSetOwn = wrapper.setOwn;
                int oldMaxLogSize = wrapper.maxLogSize;
                boolean oldFail = wrapper.failBuild;
                if (newMaxLogSize != oldMaxLogSize || newFail != oldFail || newSetOwn != oldSetOwn) {
                    changed = true;
                }
            } else {
                changed = true;
            }
            if (delete) {
                if (wrapper != null) {
                    wrappers.remove((Object)wrapper);
                }
            } else if (changed) {
                try {
                    wrapper = LogfilesizeSliceSpec.newLogfilesizecheckerWrapper(newMaxLogSize, newFail, newSetOwn);
                    wrappers.replace((Describable)wrapper);
                }
                catch (IOException e) {
                    System.err.println("IOException thrown replacing wrapper value");
                    return false;
                }
            }
            return changed;
        }

        @Override
        public String getName(BuildableItemWithBuildWrappers item) {
            return item.getName();
        }

        @Override
        public String getDefaultValueString() {
            return DISABLED;
        }

        @Override
        public String getConfiguredValueDescription() {
            return "SetOwn, MaxLogSize in MB, Fail <i>(e.g. true,7,false)</i><ul><li>Set your own maximum log size instead of using default (true/false)</li><li>Maximum log size (int) (use 0 to use global default)</li><li>Mark build as failed instead of aborted (true/false)</li></ul>";
        }

        public static LogfilesizecheckerWrapper newLogfilesizecheckerWrapper(int maxLogSize, boolean failBuild, boolean setOwn) {
            LogfilesizecheckerWrapper wrapper;
            Constructor cons;
            Class<LogfilesizecheckerWrapper> cls = LogfilesizecheckerWrapper.class;
            Class[] types = new Class[]{Integer.TYPE, Boolean.TYPE, Boolean.TYPE};
            try {
                cons = cls.getDeclaredConstructor(types);
            }
            catch (Exception e) {
                throw new UnsupportedClassVersionError("Cannot find a version of LogfilesizecheckerWrapper constructor that can be used:" + e.getMessage());
            }
            Object[] args = null;
            if (cons != null) {
                args = new Object[]{maxLogSize, failBuild, setOwn};
            }
            try {
                wrapper = (LogfilesizecheckerWrapper)cons.newInstance(args);
            }
            catch (Exception e) {
                throw new UnsupportedClassVersionError("Cannot find a version of LogfilesizecheckerWrapper constructor that can be used:" + e.getMessage());
            }
            return wrapper;
        }
    }
}

