/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.jobdisabled;

import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.AbstractProject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Extension
public class JobDisabledStringSlicer
extends UnorderedStringSlicer<AbstractProject> {
    public JobDisabledStringSlicer() {
        super(new JobDisabledStringSliceSpec());
    }

    public static class JobDisabledStringSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject> {
        @Override
        public String getDefaultValueString() {
            return null;
        }

        @Override
        public String getName() {
            return "Job Disabled Build Slicer (String)";
        }

        @Override
        public String getName(AbstractProject item) {
            return item.getFullName();
        }

        @Override
        public String getUrl() {
            return "jobdisabledstring";
        }

        @Override
        public boolean isBlankNeededForValues() {
            return false;
        }

        @Override
        public List<String> getCommonValueStrings() {
            ArrayList<String> values = new ArrayList<String>();
            values.add(String.valueOf(true));
            values.add(String.valueOf(false));
            return values;
        }

        @Override
        public List<String> getValues(AbstractProject job) {
            ArrayList<String> values = new ArrayList<String>();
            boolean isDisabled = job.isDisabled();
            values.add(String.valueOf(isDisabled));
            return values;
        }

        @Override
        public List<AbstractProject> getWorkDomain() {
            return TopLevelItemSelector.getAllTopLevelItems(AbstractProject.class);
        }

        @Override
        public boolean setValues(AbstractProject job, List<String> set) {
            boolean newDisabled;
            String value = set.iterator().next();
            boolean oldDisabled = job.isDisabled();
            if (oldDisabled != (newDisabled = Boolean.parseBoolean(value))) {
                try {
                    job.makeDisabled(newDisabled);
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

