/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.email;

import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import configurationslicing.email.ProjectHandler;
import hudson.model.AbstractProject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractEmailSliceSpec
extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject> {
    public static final String DISABLED = "(Disabled)";
    private static final String EMPTY = "";
    private String joinString;
    private String name;
    private String url;

    protected AbstractEmailSliceSpec(String joinString, String name, String url) {
        this.joinString = joinString;
        this.name = name;
        this.url = url;
    }

    @Override
    public List<String> getValues(AbstractProject project) {
        ProjectHandler handler = this.getProjectHandler(project);
        String recipients = handler.getRecipients(project);
        if ((recipients = this.normalize(recipients, "\n")) == null) {
            recipients = handler.sendToIndividuals(project) ? EMPTY : DISABLED;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(recipients);
        return values;
    }

    @Override
    public boolean setValues(AbstractProject project, List<String> set) {
        String newEmail = this.join(set);
        boolean disabled = newEmail == null ? false : DISABLED.toLowerCase().equals(newEmail.toLowerCase());
        boolean saved = false;
        ProjectHandler handler = this.getProjectHandler(project);
        try {
            if (disabled) {
                boolean oneSaved = handler.removeMailer(project);
                if (oneSaved) {
                    saved = true;
                }
            } else {
                boolean wasSet;
                boolean oneSaved = handler.addMailer(project);
                if (oneSaved) {
                    saved = true;
                }
                if (wasSet = handler.setRecipients(project, newEmail)) {
                    try {
                        project.save();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    saved = true;
                }
            }
            return saved;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String normalize(String value, String joinString) {
        if ((value = StringUtils.trimToNull((String)value)) == null) {
            return null;
        }
        if (value.startsWith("$")) {
            return value;
        }
        String[] split = value.split("[;,\\s]");
        Arrays.sort(split, String.CASE_INSENSITIVE_ORDER);
        StringBuffer buf = new StringBuffer();
        for (String s : split) {
            if (buf.length() > 0) {
                buf.append(joinString);
            }
            s = s.toLowerCase();
            buf.append(s);
        }
        return buf.toString();
    }

    public String join(Collection<String> set) {
        if (set.isEmpty()) {
            return null;
        }
        String value = set.iterator().next();
        if (!DISABLED.equals(value)) {
            value = this.normalize(value, this.joinString);
        }
        return value;
    }

    @Override
    public List<AbstractProject> getWorkDomain() {
        return TopLevelItemSelector.getAllTopLevelItems(AbstractProject.class);
    }

    protected abstract ProjectHandler getProjectHandler(AbstractProject var1);

    @Override
    public String getDefaultValueString() {
        return DISABLED;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getName(AbstractProject item) {
        return item.getFullName();
    }

    @Override
    public String getUrl() {
        return this.url;
    }
}

