/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.SecretSource;
import org.kohsuke.stapler.Stapler;

public class PrimitiveConfigurator
extends Configurator {
    private final Class target;

    public PrimitiveConfigurator(Class clazz) {
        this.target = clazz;
    }

    public Class getTarget() {
        return this.target;
    }

    @Override
    public Set<Attribute> describe() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Object configure(Object config) throws ConfiguratorException {
        Optional<String> r;
        if (config instanceof String && (r = SecretSource.requiresReveal((String)config)).isPresent()) {
            Optional<Object> reveal = Optional.empty();
            for (SecretSource secretSource : SecretSource.all()) {
                try {
                    reveal = secretSource.reveal(r.get());
                }
                catch (IOException ex) {
                    throw new ConfiguratorException(this, "Cannot reveal secret source for variable with key: " + config, ex);
                }
                if (!reveal.isPresent()) continue;
                config = reveal.get();
                break;
            }
            if (!reveal.isPresent()) {
                throw new ConfiguratorException("Unable to reveal variable with key: " + config);
            }
        }
        return Stapler.lookupConverter((Class)this.target).convert(this.target, config);
    }

    @Override
    public List<Configurator> getConfigurators() {
        return Collections.EMPTY_LIST;
    }
}

