/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProperty;
import hudson.util.PersistedList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javaposse.jobdsl.dsl.JobManagement;
import javaposse.jobdsl.plugin.JenkinsDslScriptLoader;
import javaposse.jobdsl.plugin.JenkinsJobManagement;
import javaposse.jobdsl.plugin.LookupStrategy;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.security.s2m.AdminWhitelistRule;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.BaseConfigurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.DescriptorConfigurator;
import org.jenkinsci.plugins.casc.PersistedListAttribute;
import org.jenkinsci.plugins.casc.RootElementConfigurator;

@Extension
public class JenkinsConfigurator
extends BaseConfigurator<Jenkins>
implements RootElementConfigurator<Jenkins> {
    private static final Logger LOGGER = Logger.getLogger(JenkinsConfigurator.class.getName());
    public static final Attribute.Setter NOOP = (target, attribute, value) -> LOGGER.log(Level.WARNING, "Ignoring attribute {0} for Jenkins instance. No setter", attribute.name);

    @Override
    public Class<Jenkins> getTarget() {
        return Jenkins.class;
    }

    @Override
    public Jenkins configure(Object c) throws ConfiguratorException {
        Map config = (Map)c;
        Jenkins jenkins = Jenkins.getInstance();
        this.configure(config, jenkins);
        return jenkins;
    }

    @Override
    public Set<Attribute> describe() {
        Set<Attribute> attributes = super.describe();
        Jenkins jenkins = Jenkins.getInstance();
        attributes.add(new PersistedListAttribute<Cloud>("clouds", (PersistedList<Cloud>)jenkins.clouds, Cloud.class));
        attributes.add(new Attribute("jobs", String.class).multiple(true).setter((target, attribute, value) -> {
            JenkinsJobManagement mng = new JenkinsJobManagement(System.out, (Map)new EnvVars(), null, null, LookupStrategy.JENKINS_ROOT);
            for (String script : (List)value) {
                new JenkinsDslScriptLoader((JobManagement)mng).runScript(script);
            }
        }));
        attributes.add(new Attribute("nodeProperties", NodeProperty.class).multiple(true).setter((target, attribute, value) -> jenkins.getNodeProperties().replaceBy((Collection)value)));
        attributes.add(new Attribute("globalNodeProperties", NodeProperty.class).multiple(true).setter((target, attribute, value) -> jenkins.getGlobalNodeProperties().replaceBy((Collection)value)));
        ExtensionList descriptors = jenkins.getExtensionList(Descriptor.class);
        for (Descriptor descriptor : descriptors) {
            if (descriptor.getGlobalConfigPage() == null || !(descriptor.getCategory() instanceof GlobalConfigurationCategory.Unclassified)) continue;
            DescriptorConfigurator configurator = new DescriptorConfigurator(descriptor);
            attributes.add(new Attribute(configurator.getName(), configurator.getTarget()).setter(NOOP));
        }
        attributes.add(new Attribute("remotingSecurity", AdminWhitelistRule.class).setter(NOOP));
        return attributes;
    }

    @Override
    public String getName() {
        return "jenkins";
    }
}

