/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.model.Descriptor;
import java.util.Map;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.casc.BaseConfigurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.RootElementConfigurator;

public class DescriptorConfigurator
extends BaseConfigurator<Descriptor>
implements RootElementConfigurator<Descriptor> {
    private final String name;
    private final Descriptor descriptor;
    private final Class target;

    public DescriptorConfigurator(Descriptor descriptor) {
        this.descriptor = descriptor;
        this.target = descriptor.getClass();
        Symbol symbol = descriptor.getClass().getAnnotation(Symbol.class);
        if (symbol != null) {
            this.name = symbol.value()[0];
        } else {
            String cl = descriptor.getKlass().toJavaClass().getSimpleName();
            this.name = cl.toLowerCase();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<Descriptor> getTarget() {
        return this.target;
    }

    @Override
    public Descriptor configure(Object config) throws ConfiguratorException {
        this.configure((Map)config, this.descriptor);
        return this.descriptor;
    }
}

