/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.DescriptorExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.Configurator;

public class DescribableAttribute<T>
extends Attribute<T> {
    public DescribableAttribute(String name, Class<? extends Describable> type) {
        super(name, type);
    }

    @Override
    public List<String> possibleValues() {
        DescriptorExtensionList descriptors = Jenkins.getInstance().getDescriptorList(this.type);
        return descriptors.stream().map(d -> DescribableAttribute.getSymbolName(d, this.type, d.getKlass().toJavaClass())).collect(Collectors.toList());
    }

    public static String getSymbolName(Descriptor d, Class extensionPoint, Class target) {
        if (d != null) {
            Symbol s = d.getClass().getAnnotation(Symbol.class);
            if (s != null) {
                return s.value()[0];
            }
            String ext = extensionPoint.getSimpleName();
            String cn = d.getKlass().toJavaClass().getSimpleName();
            if (cn.endsWith(ext)) {
                return Configurator.normalize(cn.substring(0, cn.length() - ext.length()));
            }
            String in = target.getSimpleName() + "Impl";
            if (cn.endsWith(in)) {
                return Configurator.normalize(cn.substring(0, cn.length() - in.length()));
            }
            return Configurator.normalize(cn);
        }
        return Configurator.normalize(target.getSimpleName());
    }
}

