/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.TopLevelItem;
import hudson.remoting.Which;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.DataBoundConfigurator;
import org.jenkinsci.plugins.casc.DescriptorConfigurator;
import org.jenkinsci.plugins.casc.ElementConfigurator;
import org.jenkinsci.plugins.casc.ExtensionConfigurator;
import org.jenkinsci.plugins.casc.HeteroDescribableConfigurator;
import org.jenkinsci.plugins.casc.PrimitiveConfigurator;
import org.jenkinsci.plugins.casc.RootElementConfigurator;
import org.jenkinsci.plugins.casc.TopLevelItemConfigurator;
import org.jvnet.tiger_types.Types;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.lang.Klass;

public abstract class Configurator<T>
implements ExtensionPoint,
ElementConfigurator<T> {
    private static final Logger logger = Logger.getLogger(Configurator.class.getName());

    @CheckForNull
    public static RootElementConfigurator lookupRootElement(String name) {
        for (RootElementConfigurator c : RootElementConfigurator.all()) {
            if (!c.getName().equalsIgnoreCase(name)) continue;
            return c;
        }
        return null;
    }

    @Nonnull
    public static Configurator lookupOrFail(Type type) throws ConfiguratorException {
        Configurator cfg = Configurator.lookup(type);
        if (cfg == null) {
            throw new ConfiguratorException("Cannot find configurator for type " + type);
        }
        return cfg;
    }

    @CheckForNull
    public static Configurator lookup(Type type) {
        Class clazz = Types.erasure((Type)type);
        Jenkins jenkins = Jenkins.getInstance();
        ExtensionList l = jenkins.getExtensionList(Configurator.class);
        for (Configurator c : l) {
            if (clazz != c.getTarget()) continue;
            return c;
        }
        if (Collection.class.isAssignableFrom(clazz) && type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type actualType = pt.getActualTypeArguments()[0];
            if (actualType instanceof WildcardType) {
                actualType = ((WildcardType)actualType).getUpperBounds()[0];
            }
            if (!(actualType instanceof Class)) {
                throw new IllegalStateException("Can't handle " + type);
            }
            return Configurator.lookup(actualType);
        }
        if (Descriptor.class.isAssignableFrom(clazz)) {
            return new DescriptorConfigurator((Descriptor)jenkins.getExtensionList(clazz).get(0));
        }
        if (Configurator.getDataBoundConstructor(clazz) != null) {
            return new DataBoundConfigurator(clazz);
        }
        if (Modifier.isAbstract(clazz.getModifiers()) && Describable.class.isAssignableFrom(clazz)) {
            return new HeteroDescribableConfigurator(clazz);
        }
        if (TopLevelItem.class.isAssignableFrom(clazz)) {
            return new TopLevelItemConfigurator(clazz);
        }
        if (Extension.class.isAssignableFrom(clazz)) {
            return new ExtensionConfigurator(clazz);
        }
        if (Stapler.lookupConverter((Class)clazz) != null) {
            return new PrimitiveConfigurator(clazz);
        }
        logger.warning("Configuration-as-Code can't handle type " + type);
        return null;
    }

    @CheckForNull
    public static Configurator lookupForBaseType(Class<?> clazz, @Nonnull String shortname) {
        Jenkins jenkins = Jenkins.getInstance();
        ExtensionList l = jenkins.getExtensionList(Configurator.class);
        for (Configurator c : l) {
            if (!shortname.equalsIgnoreCase(c.getName()) || !clazz.isAssignableFrom(c.getTarget())) continue;
            return c;
        }
        return null;
    }

    @CheckForNull
    public static Constructor getDataBoundConstructor(@Nonnull Class type) {
        for (Constructor<?> c : type.getConstructors()) {
            if (c.getAnnotation(DataBoundConstructor.class) == null) continue;
            return c;
        }
        return null;
    }

    @Nonnull
    public static String normalize(@Nonnull String name) {
        name = name.toUpperCase().equals(name) ? name.toLowerCase() : StringUtils.uncapitalize((String)name);
        return name;
    }

    @Nonnull
    public List<Configurator> getConfigurators() {
        return Collections.singletonList(this);
    }

    @Override
    public String getName() {
        Symbol annotation = this.getTarget().getAnnotation(Symbol.class);
        if (annotation != null) {
            return annotation.value()[0];
        }
        return Configurator.normalize(this.getTarget().getSimpleName());
    }

    public abstract Class<T> getTarget();

    @CheckForNull
    public Class getExtensionPoint() {
        Class<T> t = this.getTarget();
        if (ExtensionPoint.class.isAssignableFrom(t)) {
            return t;
        }
        return t;
    }

    @CheckForNull
    public String getExtensionSource() throws IOException {
        Class e = this.getExtensionPoint();
        if (e == null) {
            return null;
        }
        String jar = Which.jarFile((Class)e).getName();
        if (jar.startsWith("jenkins-core-")) {
            return "jenkins-core";
        }
        return jar.substring(0, jar.lastIndexOf(46));
    }

    @CheckForNull
    public String getDisplayName() {
        return "";
    }

    private Klass getKlass() {
        return Klass.java(this.getTarget());
    }

    @Override
    public abstract T configure(Object var1) throws ConfiguratorException;

    @Nonnull
    public List<Attribute> getAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.describe());
        Collections.sort(attributes, (a, b) -> a.name.compareTo(b.name));
        return attributes;
    }

    @CheckForNull
    public Attribute getAttribute(@Nonnull String name) {
        Set<Attribute> attrs = this.describe();
        for (Attribute attr : attrs) {
            if (!attr.name.equalsIgnoreCase(name)) continue;
            return attr;
        }
        return null;
    }

    @Override
    @Nonnull
    public abstract Set<Attribute> describe();

    @Nonnull
    public String getHtmlHelp(String attribute) throws IOException {
        URL resource = this.getKlass().getResource("help-" + attribute + ".html");
        if (resource != null) {
            return IOUtils.toString((InputStream)resource.openStream());
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (obj instanceof Configurator) {
            return this.getTarget() == ((Configurator)obj).getTarget();
        }
        return false;
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }
}

