/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;

public class Attribute<T> {
    private static final Logger logger = Logger.getLogger(Attribute.class.getName());
    protected final String name;
    protected final Class type;
    private boolean multiple;
    protected String preferredName;
    private Setter setter = DEFAULT_SETTER;
    private static final Setter DEFAULT_SETTER = (target, attribute, value) -> {
        String setterId = target.getClass().getCanonicalName() + '#' + attribute.name;
        logger.info("Setting " + setterId + " = " + value);
        PropertyDescriptor property = PropertyUtils.getPropertyDescriptor((Object)target, (String)attribute.name);
        if (property == null) {
            throw new Exception("Default value setter cannot find Property Descriptor for " + setterId);
        }
        Method writeMethod = property.getWriteMethod();
        Object[] o = value;
        if (attribute.multiple) {
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException(setterId + " should be a list.");
            }
            Class<Set> c = writeMethod.getParameterTypes()[0];
            if (c.isArray()) {
                Collection collection = (Collection)value;
                o = collection.toArray((Object[])Array.newInstance(attribute.type, collection.size()));
            } else if (c.isAssignableFrom(Set.class)) {
                o = new HashSet((Collection)value);
            }
        }
        writeMethod.invoke(target, new Object[]{o});
    };

    public Attribute(String name, Class type) {
        this.name = name;
        this.type = type;
    }

    public String toString() {
        return String.format("%s(class: %s, multiple: %s)", this.name, this.type, this.multiple);
    }

    public String getName() {
        return this.preferredName != null ? this.preferredName : this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public Attribute<T> multiple(boolean multiple) {
        this.multiple = multiple;
        return this;
    }

    public Attribute<T> preferredName(String preferredName) {
        this.preferredName = preferredName;
        return this;
    }

    public Attribute<T> setter(Setter setter) {
        this.setter = setter;
        return this;
    }

    public Setter getSetter() {
        return this.setter;
    }

    public List<String> possibleValues() {
        if (this.type.isEnum()) {
            Class e = this.type;
            return Arrays.stream(e.getEnumConstants()).map(Enum::name).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    public void setValue(T target, Object value) throws Exception {
        this.setter.setValue(target, this, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.name, attribute.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @FunctionalInterface
    public static interface Setter {
        public void setValue(Object var1, Attribute var2, Object var3) throws Exception;
    }
}

