/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.conditionalbuildstep;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkinsci.plugins.conditionalbuildstep.Messages;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@Deprecated
public class LegacyBuildstepCondition
extends RunCondition {
    private static Logger log = Logger.getLogger(LegacyBuildstepCondition.class.getName());
    private final String condition;
    private final boolean invertCondition;

    @DataBoundConstructor
    public LegacyBuildstepCondition(String condition, boolean invert) {
        this.condition = condition;
        this.invertCondition = invert;
    }

    public String getCondition() {
        return this.condition;
    }

    public boolean isInvertCondition() {
        return this.invertCondition;
    }

    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        return this.shouldRun(build, listener);
    }

    public boolean runPrebuild(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        return this.shouldRun(build, listener);
    }

    private boolean shouldRun(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        String resolvedCondition = this.condition;
        try {
            resolvedCondition = TokenMacro.expand(build, (TaskListener)listener, (String)this.condition);
        }
        catch (MacroEvaluationException e) {
            log.log(Level.FINE, "failed to resolve condition via TokenMacro: {0}", e.getMessage());
            VariableResolver variableResolver = build.getBuildVariableResolver();
            resolvedCondition = LegacyBuildstepCondition.resolveVariable((VariableResolver<String>)variableResolver, this.condition);
        }
        String string = resolvedCondition = resolvedCondition == null ? this.condition : resolvedCondition;
        boolean execute = this.invertCondition ? !"true".equalsIgnoreCase(resolvedCondition.trim()) : "true".equalsIgnoreCase(resolvedCondition.trim());
        listener.getLogger().println("ConditionalStep  [" + this.condition + "] evaluated to [" + resolvedCondition + "] (invert: " + this.invertCondition + ") execute --> " + execute);
        return execute;
    }

    public static String resolveVariable(VariableResolver<String> variableResolver, String potentalVaraible) {
        String value = potentalVaraible;
        if (potentalVaraible != null && potentalVaraible.startsWith("${") && potentalVaraible.endsWith("}")) {
            value = potentalVaraible.substring(2, potentalVaraible.length() - 1);
            value = (String)variableResolver.resolve(value);
            log.log(Level.FINE, "resolve " + potentalVaraible + " to " + value);
        }
        return value;
    }

    @Extension
    public static class LegacyConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.legacycondition_displayName();
        }

        public FormValidation doCheckCondition(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please define a condition");
            }
            if (!value.startsWith("${")) {
                return FormValidation.warning((String)"do you realy want to hard code the condition?");
            }
            return FormValidation.ok();
        }
    }
}

