/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.compatibilityaction;

import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import hudson.util.Secret;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.compatibilityaction.CompatibilityDataException;

public class MongoDBHolderService
implements Serializable {
    private Secret password;
    private String user;
    private int port;
    private String host;
    private String database;

    public MongoDBHolderService(String user, Secret password, int port, String host, String database) {
        this.user = user;
        this.password = password;
        this.host = host;
        this.database = database;
        this.port = port;
    }

    public MongoDBHolderService() {
    }

    public MongoClient createClient() throws UnknownHostException {
        if (!StringUtils.isBlank((String)Secret.toString((Secret)this.password))) {
            return new MongoClient(new ServerAddress(this.host, this.port), Arrays.asList(MongoCredential.createCredential((String)this.user, (String)this.database, (char[])Secret.toString((Secret)this.password).toCharArray())));
        }
        ServerAddress addr = new ServerAddress(this.host, this.port);
        return new MongoClient(addr);
    }

    public String testConnection(String collection) throws CompatibilityDataException {
        try {
            StringBuilder builder = new StringBuilder();
            DB db = this.createClient().getDB(this.database);
            Set collections = db.getCollectionNames();
            if (collections.isEmpty()) {
                throw new CompatibilityDataException("No collections found in database");
            }
            if (!collections.contains(collection)) {
                throw new CompatibilityDataException("The specified collection was not found in the database");
            }
            DBObject cur = db.getCollection(collection).findOne();
            builder.append("<br/>").append(cur);
            return builder.toString();
        }
        catch (UnknownHostException ex) {
            throw new CompatibilityDataException("Unable to list collections in database. Check your connection settings", ex);
        }
    }

    public Secret getPassword() {
        return this.password;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }
}

