/*
 * Decompiled with CFR 0.152.
 */
package com.robestone.hudson.compactcolumns;

import com.robestone.hudson.compactcolumns.AbstractStatusesColumn;
import com.robestone.hudson.compactcolumns.Messages;
import hudson.model.Run;
import hudson.util.ColorPalette;
import java.awt.Color;
import java.util.Locale;
import java.util.Objects;

public class BuildInfo
implements Comparable<BuildInfo> {
    public static final String UNSTABLE_COLOR = BuildInfo.toColorString(new Color(255, 165, 0));
    private static String STABLE_COLOR;
    public static final String OTHER_COLOR;
    public static final String FAILED_COLOR;
    private static final Color BLUE_FROM_PALETTE;
    private final Run<?, ?> run;
    private String color;
    private String underlineStyle;
    private String timeAgoString;
    private long buildTime;
    private String status;
    private String urlPart;
    private boolean isFirst;
    private boolean isLatestBuild;
    private boolean multipleBuilds;

    public BuildInfo(Run<?, ?> run, String color, String underlineStyle, long buildTime, String status, String urlPart, boolean isLatestBuild) {
        this.run = Objects.requireNonNull(run, "BuildInfo needs a run");
        this.color = color;
        this.underlineStyle = underlineStyle;
        this.buildTime = buildTime;
        this.status = status;
        this.urlPart = urlPart;
        this.isLatestBuild = isLatestBuild;
    }

    public static String getUnstableColorString() {
        return UNSTABLE_COLOR;
    }

    public static String getFailedColorString() {
        return FAILED_COLOR;
    }

    public static String getStableColorString() {
        if (STABLE_COLOR == null) {
            STABLE_COLOR = BuildInfo.toColorString(BuildInfo.getStableColor());
        }
        return STABLE_COLOR;
    }

    static Color getStableColor() {
        boolean isPaletteStandard = BLUE_FROM_PALETTE.equals(ColorPalette.BLUE);
        if (isPaletteStandard) {
            return Color.BLUE;
        }
        return ColorPalette.BLUE;
    }

    static String toColorString(Color color) {
        StringBuilder buf = new StringBuilder("#");
        try {
            String hex = Integer.toHexString(color.getRGB() & 0xFFFFFF);
            String zeroes = "000000";
            int len = zeroes.length() - hex.length();
            buf.append(zeroes.substring(0, len));
            buf.append(hex);
        }
        catch (Throwable t) {
            buf.append(t.getMessage());
        }
        return buf.toString();
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public String getColor() {
        return this.color;
    }

    public String getTimeAgoString() {
        return this.timeAgoString;
    }

    public String getStatus() {
        return this.status;
    }

    public String getUrlPart() {
        return this.urlPart;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public boolean isLatestBuild() {
        return this.isLatestBuild;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public boolean isMultipleBuilds() {
        return this.multipleBuilds;
    }

    public String getLatestBuildString(Locale locale) {
        if (this.isLatestBuild) {
            return " (" + Messages.latestBuild() + ")";
        }
        return "";
    }

    public String getStartedAgo(Locale locale) {
        return Messages._startedAgo(this.timeAgoString).toString(locale);
    }

    public String getBuiltAt(Locale locale) {
        String time = AbstractStatusesColumn.getBuildTimeString(this.buildTime, locale);
        return Messages._builtAt(time).toString(locale);
    }

    public String getLastedDuration(Locale locale) {
        return Messages._lastedDuration(this.run.getDurationString()).toString(locale);
    }

    public String getFontWeight() {
        if (this.isLatestBuild && this.multipleBuilds) {
            return "bold";
        }
        return "normal";
    }

    public String getUnderlineStyle() {
        if (this.underlineStyle == null) {
            return "0px";
        }
        return this.underlineStyle;
    }

    public void setFirst(boolean first) {
        this.isFirst = first;
    }

    public void setMultipleBuilds(boolean multipleBuilds) {
        this.multipleBuilds = multipleBuilds;
    }

    public void setTimeAgoString(String timeAgoString) {
        this.timeAgoString = timeAgoString;
    }

    @Override
    public int compareTo(BuildInfo that) {
        return Integer.compare(that.run.number, this.run.number);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildInfo buildInfo = (BuildInfo)o;
        return this.run.number == buildInfo.run.number;
    }

    public int hashCode() {
        return Integer.hashCode(this.run.number);
    }

    public String getTextDecoration() {
        if (this.underlineStyle == null) {
            return "underline";
        }
        return "none";
    }

    static {
        OTHER_COLOR = BuildInfo.toColorString(ColorPalette.GREY);
        FAILED_COLOR = BuildInfo.toColorString(ColorPalette.RED);
        BLUE_FROM_PALETTE = new Color(114, 159, 207);
    }
}

