/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.orchestrate;

import com.collabnet.ce.soap60.webservices.ClientSoapStubFactory;
import com.collabnet.ce.soap60.webservices.cemain.ICollabNetSoap;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.collabnet.orchestrate.BuildNotifier;
import hudson.plugins.collabnet.util.Helper;
import hudson.util.DescribableList;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.validator.routines.UrlValidator;

public class TraceabilityAction
implements Action {
    private final transient AbstractBuild build;
    private static final String BLANK_TFURL = "TeamForge site URL is missing. Please enter valid TeamForge site URL";
    private static final String BLANK_CREDENTIALS = "TeamForge username or password is missing. Please enter valid TeamForge user credentials.";
    private static final String INVALID_TFURL = "TeamForge site URL is invalid";
    private static final String EMPTY_STRING = "";
    Logger logger = Logger.getLogger(this.getClass().getName());
    private String errorMessage;

    public TraceabilityAction(AbstractBuild abstractBuild) {
        this.build = abstractBuild;
    }

    public String getIconFileName() {
        if (this.getNotifier() != null) {
            return "/plugin/collabnet/images/48x48/TeamForgeAssociations.png";
        }
        return null;
    }

    public String getDisplayName() {
        if (this.getNotifier() != null) {
            return "TeamForge Associations";
        }
        return null;
    }

    public String getUrlName() {
        return "teamforge";
    }

    public AbstractBuild getBuild() {
        return this.build;
    }

    private BuildNotifier getNotifier() {
        DescribableList publisherList = this.build.getProject().getPublishersList();
        return (BuildNotifier)publisherList.get(BuildNotifier.class);
    }

    public String getCtfUrl() {
        return this.getNotifier().getCtfUrl();
    }

    public String getCtfUser() {
        return this.getNotifier().getCtfUser();
    }

    public String getCtfPassword() {
        return this.getNotifier().getCtfPassword();
    }

    public String getSourceKey() {
        return this.getNotifier().getSourceKey();
    }

    public String getReqUrl() {
        String ctfUrl = this.getCtfUrl();
        return ctfUrl + "/orc/api/2/reporting";
    }

    public boolean getAssociationView() {
        return this.getNotifier().getUseAssociationView();
    }

    public boolean getValidation() {
        if (this.isSupportEventQ() && this.isSupportWebhook()) {
            this.addErrorMsg("TeamForge Association - Both TeamForge and EventQ configured. Please use either one option.");
            return true;
        }
        if (!this.getAssociationView()) {
            this.addErrorMsg("TeamForge Association view not configured.");
            return true;
        }
        String ctfUrl = this.getCtfUrl();
        String ctfUserName = this.getCtfUser();
        String ctfPassword = this.getCtfPassword();
        if (ctfUrl.isEmpty()) {
            this.addErrorMsg(BLANK_TFURL);
            return true;
        }
        if (ctfUserName.isEmpty() || ctfPassword == null) {
            this.addErrorMsg(BLANK_CREDENTIALS);
            return true;
        }
        String soapSession = this.getSoapSessionId();
        return soapSession.isEmpty();
    }

    public void addErrorMsg(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMsg() {
        return this.errorMessage;
    }

    public String getSoapSessionId() {
        String ctfUrl = this.getCtfUrl();
        String ctfUserName = this.getCtfUser();
        String ctfPassword = this.getCtfPassword();
        try {
            URL url = this.getUrl(ctfUrl);
            this.validateCtfUrl(url);
            return this.getCtfSession(url, ctfUserName, ctfPassword);
        }
        catch (MalformedURLException e) {
            this.addErrorMsg(INVALID_TFURL);
            this.logger.log(Level.INFO, INVALID_TFURL, e);
            return EMPTY_STRING;
        }
        catch (URISyntaxException e) {
            this.addErrorMsg(INVALID_TFURL);
            this.logger.log(Level.INFO, INVALID_TFURL, e);
            return EMPTY_STRING;
        }
        catch (RemoteException e) {
            String errMsg = e.getMessage();
            if (errMsg.startsWith("(301)Moved Permanently")) {
                this.addErrorMsg("Connection refused. Please check the configuration.");
            } else if (errMsg.startsWith("(301)Redirect")) {
                this.addErrorMsg("Connection refused. Please check the configuration.");
            } else if (errMsg.startsWith("; nested exception is: \n\tjava.net.UnknownHostException:")) {
                this.addErrorMsg("TeamForge configuration is invalid");
            } else if (errMsg.startsWith("; nested exception is: \n\tjavax.net.ssl.SSLHandshakeException: ")) {
                this.addErrorMsg("SSL configuration error. Please check your SSL certificate and retry.");
            } else if (errMsg.endsWith("java.net.SocketTimeoutException: connect timed out")) {
                this.addErrorMsg("Connection timed out. Please check the configuration.");
            } else if (errMsg.endsWith("java.net.ConnectException: Connection timed out")) {
                this.addErrorMsg("Connection timed out. Please check the configuration.");
            } else if (errMsg.endsWith("java.net.NoRouteToHostException: No route to host")) {
                this.addErrorMsg("Connection refused. Please check the configuration.");
            } else if (errMsg.endsWith(": Connection refused")) {
                this.addErrorMsg("Connection refused. Please check the configuration.");
            } else {
                this.addErrorMsg(e.getLocalizedMessage());
            }
            this.logger.log(Level.INFO, "TeamForge Associations - " + e.getLocalizedMessage(), e);
            return EMPTY_STRING;
        }
    }

    private URL getUrl(String ctfUrl) throws URISyntaxException, MalformedURLException {
        return new URL(ctfUrl);
    }

    private String getCtfSession(URL ctfUrl, String ctfUserName, String ctfPassword) throws RemoteException {
        ICollabNetSoap cnWebService = (ICollabNetSoap)ClientSoapStubFactory.getSoapStub(ICollabNetSoap.class, (String)String.format("%s://%s/ce-soap60/services/CollabNet", ctfUrl.getProtocol(), ctfUrl.getHost()));
        return cnWebService.login(ctfUserName, ctfPassword);
    }

    private void validateCtfUrl(URL ctfUrl) throws URISyntaxException {
        UrlValidator urlValidator = new UrlValidator(8L);
        if (!urlValidator.isValid(ctfUrl.toString())) {
            throw new URISyntaxException("URISyntaxException", "Invalid url");
        }
    }

    public String getCtfRestUrl() {
        String ctfUrl = this.getCtfUrl();
        return ctfUrl + "/ctfrest/foundation/v1/associations?ids=build:" + this.getBuild().getNumber();
    }

    public String getTokenId() throws IOException {
        String ctfUrl = this.getCtfUrl();
        String ctfUserName = this.getCtfUser();
        String ctfPassword = this.getCtfPassword();
        try {
            URL url = this.getUrl(ctfUrl);
            this.validateCtfUrl(url);
            return Helper.getToken(url, ctfUserName, ctfPassword);
        }
        catch (MalformedURLException e) {
            this.addErrorMsg(INVALID_TFURL);
            this.logger.log(Level.INFO, INVALID_TFURL, e);
            return EMPTY_STRING;
        }
        catch (URISyntaxException e) {
            this.addErrorMsg(INVALID_TFURL);
            this.logger.log(Level.INFO, INVALID_TFURL, e);
            return EMPTY_STRING;
        }
    }

    public boolean isSupportEventQ() {
        return this.getNotifier().getSupportEventQ();
    }

    public boolean isSupportWebhook() {
        return this.getNotifier().getSupportWebhook();
    }
}

