/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.orchestrate;

import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.collabnet.orchestrate.BuildEvent;
import hudson.plugins.collabnet.orchestrate.BuildNotifier;
import hudson.plugins.collabnet.util.CNFormFieldValidator;
import hudson.plugins.collabnet.util.Helper;
import java.io.IOException;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class PushNotification {
    Logger logger = Logger.getLogger(this.getClass().getName());

    public void handle(Run build, BuildNotifier.OptionalWebhook webhook, TaskListener listener, String status, boolean excludeCommitInfo) throws IOException {
        int response = 0;
        String token = null;
        listener.getLogger().println("Send build notification to : " + webhook.getWebhookUrl());
        JSONObject payload = this.getPayload(build, listener, status, excludeCommitInfo);
        if (this.verifyBuildMessage(payload) && (token = Helper.getWebhookToken(this.getWebhookLogin(webhook.getWebhookUrl()), webhook.getWebhookUsername(), webhook.getWebhookPassword(), listener)) != null) {
            response = this.send(webhook.getWebhookUrl(), token, payload.toString(), listener);
        }
        if (response == 201 || response == 200) {
            listener.getLogger().println("Build notification sent successfully.");
        } else if (response == 400 || token == null) {
            Helper.markUnstable(build, listener.getLogger(), "Build notification failed", this.getClass().getName());
            listener.getLogger().println("Response: 400 Bad Request- Check your webhook configuration or registered event publisher.");
            listener.getLogger().println("Build message - " + payload.toString());
        } else {
            Helper.markUnstable(build, listener.getLogger(), "Build notification failed", this.getClass().getName());
            listener.getLogger().println("Build message - " + payload.toString());
        }
    }

    private String getWebhookLogin(String webhookUrl) {
        String url = webhookUrl.substring(0, webhookUrl.indexOf("/inbox")).concat("/login");
        return url;
    }

    private boolean verifyBuildMessage(JSONObject payload) {
        return payload.get("repository") != null || payload.getJSONObject("repository").get("revisions") != null;
    }

    public JSONObject getPayload(Run build, TaskListener listener, String status, boolean excludeCommitInfo) throws IOException {
        return BuildEvent.constructJson(build, listener, status, excludeCommitInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int send(String webhookUrl, String token, String buildData, TaskListener listener) throws IOException {
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        int status = 0;
        try {
            client = CNFormFieldValidator.getHttpClient();
            HttpPost httpPost = new HttpPost(webhookUrl);
            StringEntity entity = new StringEntity(buildData);
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Authorization", token);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            response = client.execute((HttpUriRequest)httpPost);
            status = response.getStatusLine().getStatusCode();
        }
        catch (IOException e) {
            String errMsg = e.getMessage();
            Helper.logMsg(errMsg, listener, this.logger, e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
        return status;
    }
}

