/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.collabnet.auth;

import hudson.model.Hudson;
import hudson.plugins.collabnet.auth.CNAuthentication;
import hudson.security.ACL;
import hudson.security.Permission;
import java.util.Collection;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;

public class CNRootACL
extends ACL {
    private Collection<String> adminUsers;
    private Collection<String> adminGroups;
    private Collection<String> readUsers;
    private Collection<String> readGroups;
    private ACL innerACL;
    private static Logger log = Logger.getLogger("CNRootACL");

    public CNRootACL(Collection<String> adminUsers, Collection<String> adminGroups, Collection<String> readUsers, Collection<String> readGroups) {
        this(adminUsers, adminGroups, readUsers, readGroups, null);
    }

    public CNRootACL(Collection<String> adminUsers, Collection<String> adminGroups, Collection<String> readUsers, Collection<String> readGroups, ACL innerACL) {
        this.adminUsers = adminUsers;
        this.adminGroups = adminGroups;
        this.readUsers = readUsers;
        this.readGroups = readGroups;
        this.innerACL = innerACL;
    }

    public boolean hasPermission(Authentication a, Permission p) {
        if (a.equals(ACL.SYSTEM)) {
            return true;
        }
        String username = (String)a.getPrincipal();
        if (!username.equals("anonymous")) {
            if (p.equals((Object)Hudson.READ)) {
                return true;
            }
            CNAuthentication auth = CNAuthentication.cast(a);
            if (auth == null) {
                if (this.innerACL != null) {
                    return this.innerACL.hasPermission(a, p);
                }
                log.severe("Improper Authentication type used with CNAuthorizationStrategy!  CNAuthorization strategy cannot be used without CNAuthentication.  Please re-configure your Jenkins instance.");
                return false;
            }
            if (auth.isSuperUser() || this.adminUsers.contains(username) || auth.isMemberOfAny(this.adminGroups)) {
                return true;
            }
            if (this.readUsers.contains(username) || auth.isMemberOfAny(this.readGroups)) {
                Permission permission = p;
                while (permission != null) {
                    if (permission.equals((Object)Permission.READ)) {
                        return true;
                    }
                    permission = permission.impliedBy;
                }
            }
        }
        if (this.innerACL != null) {
            return this.innerACL.hasPermission(a, p);
        }
        return false;
    }
}

