/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.ce.webservices;

import com.collabnet.ce.soap60.webservices.cemain.UserSoapRow;
import com.collabnet.ce.soap60.webservices.rbac.RoleSoapDO;
import com.collabnet.ce.soap60.webservices.rbac.RoleSoapRow;
import com.collabnet.ce.webservices.CTFList;
import com.collabnet.ce.webservices.CTFObject;
import com.collabnet.ce.webservices.CTFProject;
import com.collabnet.ce.webservices.CTFUser;
import com.collabnet.ce.webservices.ObjectWithTitle;
import java.rmi.RemoteException;

public class CTFRole
extends CTFObject
implements ObjectWithTitle {
    private final String title;
    private final String description;

    public CTFRole(CTFProject parent, RoleSoapDO data) {
        super(parent, data.getId());
        this.title = data.getTitle();
        this.description = data.getDescription();
    }

    public CTFRole(CTFProject parent, RoleSoapRow data) {
        super(parent, data.getId());
        this.title = data.getTitle();
        this.description = data.getDescription();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public CTFList<CTFUser> getMembers() throws RemoteException {
        CTFList<CTFUser> r = new CTFList<CTFUser>();
        for (UserSoapRow row : this.app.getRbacAppSoap().getRoleMemberList(this.app.getSessionId(), this.getId()).getDataRows()) {
            r.add(new CTFUser(this.app, row));
        }
        return r;
    }

    public void grant(String username) throws RemoteException {
        this.app.getRbacAppSoap().addUser(this.app.getSessionId(), this.getId(), username);
    }

    public void grant(CTFUser u) throws RemoteException {
        this.grant(u.getUserName());
    }
}

